/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.util;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.utility.Utility;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
public class DockerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerHelper.class);
    private static final String REPO_IMAGE_NAME = "repository";
    private DockerClient dockerClient;

    @Autowired
    public DockerHelper(@Value(value="${docker.host}") String dockerHost) {
        this.dockerClient = SystemUtils.IS_OS_WINDOWS ? DockerClientBuilder.getInstance((String)dockerHost).withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory()).build() : DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory()).build();
    }

    private List<String> getDockerLogs(String containerId, int timeStamp) {
        final ArrayList<String> logs = new ArrayList<String>();
        LogContainerCmd logContainerCmd = this.getDockerClient().logContainerCmd(containerId);
        logContainerCmd.withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withSince(Integer.valueOf(timeStamp)).withTimestamps(Boolean.valueOf(true));
        try {
            (logContainerCmd.exec((ResultCallback)new LogContainerResultCallback(this){

                public void onNext(Frame item) {
                    logs.add(item.toString());
                }
            })).awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Failed to retrieve logs of container " + containerId, (Throwable)e);
        }
        return logs;
    }

    public List<String> getAlfrescoLogs() {
        List<Container> alfrescoContainers = this.findContainersByImageName(REPO_IMAGE_NAME);
        if (alfrescoContainers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> alfrescoLogs = new ArrayList<String>();
        int timeStamp = (int)(System.currentTimeMillis() / 1000L) - 10;
        alfrescoContainers.forEach(alfrescoContainer -> alfrescoLogs.addAll(this.getDockerLogs(alfrescoContainer.getId(), timeStamp)));
        return alfrescoLogs;
    }

    public void checkExceptionIsInAlfrescoLogs(String expectedException) throws Exception {
        Utility.sleep((int)6000, (int)30000, () -> {
            List<String> alfrescoLogs = this.getAlfrescoLogs();
            Assert.assertTrue((boolean)alfrescoLogs.stream().anyMatch(logLine -> logLine.contains(expectedException)));
        });
    }

    private List<Container> findContainersByImageName(String imageName) {
        List containers = (List)this.getDockerClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        return containers.stream().filter(container -> container.getImage().contains(imageName)).collect(Collectors.toList());
    }

    @Generated
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Generated
    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

