/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class AuditUserEventsTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditUserEventsTests.class);
    private UserModel createUser;
    @Autowired
    private RMAuditService rmAuditService;

    @Test
    @AlfrescoTest(jira="RM-6223")
    public void createUserEventIsAudited() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Create a new user.");
        String userName = "auditCreateUser" + this.PREFIX;
        this.createUser = this.getDataUser().createUser(userName);
        Step.STEP((String)"Check the audit log contains the entry for the created user event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.CREATE_PERSON, this.getAdminUser(), userName, Collections.singletonList(ImmutableMap.of((Object)"new", (Object)userName, (Object)"previous", (Object)"", (Object)"name", (Object)"User Name")));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() {
        this.getDataUser().deleteUser(this.createUser);
    }
}

