/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordcategories;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.DataProviderClass;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildCollection;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildProperties;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.requests.gscore.api.FilePlanAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RecordCategoriesAPI;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.Bug;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RecordCategoryTests
extends BaseRMRestTest {
    public static final String RECORD_CATEGORY_NAME = "CATEGORY NAME" + RandomData.getRandomAlphanumeric();
    private static final int NUMBER_OF_CHILDREN = 10;
    private static final int NUMBER_OF_FOLDERS = 5;
    @Autowired
    private RecordCategoriesAPI recordCategoriesAPI;

    @DataProvider(name="invalidContainersToDelete")
    public Object[][] getNodesToDelete() {
        return new String[][]{{"-filePlan-"}, {"-unfiled-"}, {"-transfers-"}, {this.createCategoryFolderInFilePlan(this.getAdminUser()).getId()}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId()}};
    }

    @Test(description="Rename root category")
    public void renameCategory() {
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
        RecordCategory rootRecordCategory = this.createRootCategory(categoryName, categoryTitle);
        String newCategoryName = "Rename " + categoryName;
        RecordCategory recordCategoryUpdated = RecordCategory.builder().name(newCategoryName).build();
        RecordCategory renamedRecordCategory = this.getRestAPIFactory().getRecordCategoryAPI().updateRecordCategory(recordCategoryUpdated, rootRecordCategory.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)renamedRecordCategory.getName(), (String)newCategoryName);
        FilePlan filePlan = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        Assert.assertEquals((String)renamedRecordCategory.getParentId(), (String)filePlan.getId());
    }

    @Test(description="Delete category")
    public void deleteCategory() {
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
        RecordCategory rootRecordCategory = this.createRootCategory(categoryName, categoryTitle);
        int totalEntries = this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories("-filePlan-").getPagination().getTotalItems();
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        String recordCategoryId = rootRecordCategory.getId();
        recordCategoryAPI.deleteRecordCategory(recordCategoryId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        recordCategoryAPI.getRecordCategory(recordCategoryId);
        this.assertStatusCode(HttpStatus.NOT_FOUND);
        int totalEntriesAfterDelete = this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories("-filePlan-").getPagination().getTotalItems();
        Assert.assertEquals((int)totalEntriesAfterDelete, (int)(totalEntries - 1));
    }

    @Test(description="Delete invalid nodes with delete category endpoint", dataProvider="invalidContainersToDelete")
    public void deleteInvalidNodes(String nodeId) {
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        recordCategoryAPI.deleteRecordCategory(nodeId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(description="Create child category")
    public void createSubcategory() {
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomAlphanumeric());
        Assert.assertNotNull((Object)rootCategory.getId());
        RecordCategoryChild recordCategory = this.createRecordCategoryChild(rootCategory.getId(), RECORD_CATEGORY_NAME, "rma:recordCategory");
        Assert.assertNotNull((Object)recordCategory.getId());
        Assert.assertEquals((String)recordCategory.getParentId(), (String)rootCategory.getId());
        Assert.assertTrue((boolean)recordCategory.getIsRecordCategory());
        Assert.assertFalse((boolean)recordCategory.getIsRecordFolder());
        Assert.assertEquals((String)recordCategory.getNodeType(), (String)"rma:recordCategory");
        RecordCategory subCategory = this.getRestAPIFactory().getRecordCategoryAPI().getRecordCategory(recordCategory.getId(), "include=isRecordCategory,isRecordFolder");
        Assert.assertEquals((String)subCategory.getParentId(), (String)rootCategory.getId());
        Assert.assertEquals((String)subCategory.getNodeType(), (String)"rma:recordCategory");
        Assert.assertFalse((boolean)subCategory.getAspectNames().isEmpty());
        Assert.assertNotNull((Object)subCategory.getProperties().getIdentifier());
    }

    @Test(description="Create a record folder into a record category.", dataProviderClass=DataProviderClass.class, dataProvider="folderTypes")
    @Bug(id="RM-4572")
    public void createFolderTest(String folderType) {
        RecordCategory rootRecordCategory = this.createRootCategory(RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric());
        RecordCategoryChild recordFolder = this.createRecordCategoryChild(rootRecordCategory.getId(), TestData.RECORD_FOLDER_NAME, folderType);
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)rootRecordCategory.getId(), (String)recordFolder.getParentId());
        Assert.assertFalse((boolean)recordFolder.getIsRecordCategory());
        Assert.assertTrue((boolean)recordFolder.getIsRecordFolder());
        Assert.assertEquals((String)recordFolder.getName(), (String)TestData.RECORD_FOLDER_NAME);
        Assert.assertEquals((String)recordFolder.getNodeType(), (String)"rma:recordFolder");
        Assert.assertEquals((String)recordFolder.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        RecordCategoryChildProperties folderProperties = recordFolder.getProperties();
        Assert.assertEquals((String)folderProperties.getTitle(), (String)("Title for " + TestData.RECORD_FOLDER_NAME));
        Assert.assertNotNull((Object)folderProperties.getIdentifier());
    }

    @Test(dataProviderClass=DataProviderClass.class, dataProvider="categoryChild")
    @Bug(id="RM-5116")
    public void createdDuplicateChild(String childType) {
        String rootRecordCategory = this.createRootCategory(RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric()).getId();
        RecordCategoryChild recordFolder = this.createRecordCategoryChild(rootRecordCategory, TestData.RECORD_FOLDER_NAME, childType);
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)recordFolder.getName(), (String)TestData.RECORD_FOLDER_NAME);
        RecordCategoryChild recordFolderDuplicate = this.getRestAPIFactory().getRecordCategoryAPI().createRecordCategoryChild(FilePlanComponentsUtil.createRecordCategoryChildModel(TestData.RECORD_FOLDER_NAME, childType), rootRecordCategory);
        this.assertStatusCode(HttpStatus.CONFLICT);
        recordFolderDuplicate = this.getRestAPIFactory().getRecordCategoryAPI().createRecordCategoryChild(FilePlanComponentsUtil.createRecordCategoryChildModel(TestData.RECORD_FOLDER_NAME, childType), rootRecordCategory, "autoRename=true");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertNotEquals((Object)recordFolderDuplicate.getName(), (Object)TestData.RECORD_FOLDER_NAME);
        Assert.assertTrue((boolean)recordFolderDuplicate.getName().contains(TestData.RECORD_FOLDER_NAME));
    }

    @Test(description="Get children of a record category excluding the disposition schedule")
    @Bug(id="RM-5115")
    public void getRecordCategoryChildren() {
        RecordCategory rootRecordCategory = this.createRootCategory(RandomData.getRandomAlphanumeric());
        Assert.assertNotNull((Object)rootRecordCategory.getId());
        String userName = this.getAdminUser().getUsername();
        String userPassword = this.getAdminUser().getPassword();
        String categoryName = rootRecordCategory.getName();
        this.recordCategoriesAPI.createRetentionSchedule(userName, userPassword, categoryName);
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> cutOffStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "cutoff");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, "day|2");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Cut off after 2 days");
        this.recordCategoriesAPI.addDispositionScheduleSteps(userName, userPassword, categoryName, cutOffStep);
        ArrayList<RecordCategoryChild> children = new ArrayList<RecordCategoryChild>();
        for (int i = 0; i < 10; ++i) {
            RecordCategoryChild child = this.createRecordCategoryChild(rootRecordCategory.getId(), RandomData.getRandomAlphanumeric(), i <= 5 ? "rma:recordCategory" : "rma:recordFolder");
            Assert.assertNotNull((Object)child.getId());
            children.add(child);
        }
        RecordCategoryChildCollection recordCategoryChildren = this.getRestAPIFactory().getRecordCategoryAPI().getRecordCategoryChildren(rootRecordCategory.getId(), "include=isRecordCategory,isRecordFolder");
        this.assertStatusCode(HttpStatus.OK);
        this.logger.info((Object)("Parent: " + rootRecordCategory.getId()));
        recordCategoryChildren.getEntries().forEach(c -> {
            RecordCategoryChild recordCategoryChild = c.getEntry();
            String recordCategoryChildId = recordCategoryChild.getId();
            Assert.assertNotNull((Object)recordCategoryChildId);
            this.logger.info((Object)("Checking child " + recordCategoryChildId));
            try {
                RecordCategoryChild createdComponent = children.stream().filter(child -> child.getId().equals(recordCategoryChildId)).findFirst().orElseThrow();
                Assert.assertEquals((String)recordCategoryChild.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                Assert.assertEquals((String)recordCategoryChild.getParentId(), (String)rootRecordCategory.getId());
                if (recordCategoryChild.getNodeType().equals("rma:recordCategory")) {
                    Assert.assertTrue((boolean)recordCategoryChild.getIsRecordCategory());
                    Assert.assertFalse((boolean)recordCategoryChild.getIsRecordFolder());
                } else {
                    Assert.assertTrue((boolean)recordCategoryChild.getIsRecordFolder());
                    Assert.assertFalse((boolean)recordCategoryChild.getIsRecordCategory());
                }
                Assert.assertEquals((String)createdComponent.getName(), (String)recordCategoryChild.getName());
                Assert.assertEquals((String)createdComponent.getNodeType(), (String)recordCategoryChild.getNodeType());
                Assert.assertNotNull((Object)createdComponent.getProperties().getIdentifier());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + recordCategoryChildId));
            }
        });
    }

    @Test(description="Create node types not allowed inside a category", dataProviderClass=DataProviderClass.class, dataProvider="childrenNotAllowedForCategory")
    @Bug(id="RM-4367, RM-4572")
    public void createTypesNotAllowedInCategory(String nodeType) {
        String componentName = "Component" + RandomData.getRandomAlphanumeric();
        RecordCategory rootRecordCategory = this.createRootCategory(componentName);
        this.createRecordCategoryChild(rootRecordCategory.getId(), componentName, nodeType);
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Get children of a record category")
    public void getFolders() {
        RecordCategory rootRecordCategory = this.createRootCategory(RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric());
        ArrayList<RecordCategoryChild> children = new ArrayList<RecordCategoryChild>();
        for (int i = 0; i < 5; ++i) {
            RecordCategoryChild recordCategoryChild = this.createRecordFolder(rootRecordCategory.getId(), RandomData.getRandomAlphanumeric());
            Assert.assertNotNull((Object)recordCategoryChild.getId());
            children.add(recordCategoryChild);
        }
        RecordCategoryChildCollection recordCategoryChildren = this.getRestAPIFactory().getRecordCategoryAPI().getRecordCategoryChildren(rootRecordCategory.getId(), "include=isRecordCategory,isRecordFolder");
        this.assertStatusCode(HttpStatus.OK);
        recordCategoryChildren.getEntries().forEach(c -> {
            RecordCategoryChild recordCategoryChild = c.getEntry();
            String recordCategoryChildId = recordCategoryChild.getId();
            Assert.assertNotNull((Object)recordCategoryChildId);
            this.logger.info((Object)("Checking child " + recordCategoryChildId));
            try {
                RecordCategoryChild createdComponent = children.stream().filter(child -> child.getId().equals(recordCategoryChildId)).findFirst().orElseThrow();
                Assert.assertEquals((String)recordCategoryChild.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                Assert.assertEquals((String)recordCategoryChild.getParentId(), (String)rootRecordCategory.getId());
                Assert.assertTrue((boolean)recordCategoryChild.getIsRecordFolder());
                Assert.assertFalse((boolean)recordCategoryChild.getIsRecordCategory());
                Assert.assertEquals((String)createdComponent.getName(), (String)recordCategoryChild.getName());
                Assert.assertEquals((String)createdComponent.getNodeType(), (String)recordCategoryChild.getNodeType());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + recordCategoryChildId));
            }
        });
    }

    @Test(description="Create a folder using record-categories endpoint, based on the relativePath. Containers in the relativePath that do not exist are created before the node is created")
    public void createRecordFolderWithRelativePath() {
        RecordCategory recordCategoryModel = RecordCategory.builder().name(RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric()).nodeType("rma:recordCategory").build();
        FilePlanAPI filePlansAPI = this.getRestAPIFactory().getFilePlansAPI();
        RecordCategory createRootRecordCategory = filePlansAPI.createRootRecordCategory(recordCategoryModel, "-filePlan-", "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        String recordCategoryId = createRootRecordCategory.getId();
        String relativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + LocalDateTime.now().getDayOfMonth();
        RecordCategoryChild recordFolderModel = RecordCategoryChild.builder().name(TestData.RECORD_FOLDER_NAME).nodeType("rma:recordFolder").relativePath(relativePath).build();
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        RecordCategoryChild recordCategoryChild = recordCategoryAPI.createRecordCategoryChild(recordFolderModel, recordCategoryId, "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertFalse((boolean)recordCategoryChild.getIsRecordCategory());
        Assert.assertTrue((boolean)recordCategoryChild.getIsRecordFolder());
        Assert.assertTrue((boolean)recordCategoryChild.getPath().getName().contains(relativePath));
        Assert.assertNotNull((Object)recordCategoryAPI.getRecordCategory(recordCategoryChild.getParentId()).getId());
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        RecordFolder recordFolder = recordFolderAPI.getRecordFolder(recordCategoryChild.getId(), "include=path");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)recordFolder.getNodeType(), (String)"rma:recordFolder");
        Assert.assertTrue((boolean)recordFolder.getPath().getName().contains(relativePath));
        String newRelativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + (LocalDateTime.now().getDayOfMonth() + 1);
        RecordCategoryChild newRecordFolderModel = RecordCategoryChild.builder().name(TestData.RECORD_FOLDER_NAME).nodeType("rma:recordFolder").relativePath(newRelativePath).build();
        RecordCategoryChild newRecordCategoryChild = recordCategoryAPI.createRecordCategoryChild(newRecordFolderModel, recordCategoryId, "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertFalse((boolean)newRecordCategoryChild.getIsRecordCategory());
        Assert.assertTrue((boolean)newRecordCategoryChild.getIsRecordFolder());
        Assert.assertTrue((boolean)newRecordCategoryChild.getPath().getName().contains(newRelativePath));
        Assert.assertNotNull((Object)recordCategoryAPI.getRecordCategory(newRecordCategoryChild.getParentId()).getId());
        RecordFolder newRecordFolder = recordFolderAPI.getRecordFolder(newRecordCategoryChild.getId(), "include=path");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)recordFolder.getNodeType(), (String)"rma:recordFolder");
        Assert.assertTrue((boolean)newRecordFolder.getPath().getName().contains(newRelativePath));
    }

    @Test(description="Create a sub-category using record-categories endpoint, based on the relativePath. Containers in the relativePath that do not exist are created before the node is created")
    public void createRecordSubCategoryWithRelativePath() {
        RecordCategory recordCategoryModel = RecordCategory.builder().name(RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric()).nodeType("rma:recordCategory").build();
        FilePlanAPI filePlansAPI = this.getRestAPIFactory().getFilePlansAPI();
        RecordCategory createRootRecordCategory = filePlansAPI.createRootRecordCategory(recordCategoryModel, "-filePlan-", "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        String recordCategoryId = createRootRecordCategory.getId();
        String relativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + LocalDateTime.now().getDayOfMonth() + "/" + RandomData.getRandomAlphanumeric();
        RecordCategoryChild recordFolderModel = RecordCategoryChild.builder().name(RECORD_CATEGORY_NAME).nodeType("rma:recordCategory").relativePath(relativePath).build();
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        RecordCategoryChild recordCategoryChild = recordCategoryAPI.createRecordCategoryChild(recordFolderModel, recordCategoryId, "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)recordCategoryChild.getIsRecordCategory());
        Assert.assertFalse((boolean)recordCategoryChild.getIsRecordFolder());
        Assert.assertTrue((boolean)recordCategoryChild.getPath().getName().contains(relativePath));
        Assert.assertNotNull((Object)recordCategoryAPI.getRecordCategory(recordCategoryChild.getParentId()).getId());
        RecordCategory recordSubCategory = recordCategoryAPI.getRecordCategory(recordCategoryChild.getId(), "include=path");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)recordSubCategory.getNodeType(), (String)"rma:recordCategory");
        Assert.assertTrue((boolean)recordSubCategory.getPath().getName().contains(relativePath));
        String newRelativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + (LocalDateTime.now().getDayOfMonth() + 1) + "/" + RandomData.getRandomAlphanumeric();
        RecordCategoryChild newRecordFolderModel = RecordCategoryChild.builder().name(RECORD_CATEGORY_NAME).nodeType("rma:recordCategory").relativePath(newRelativePath).build();
        RecordCategoryChild newRecordCategoryChild = recordCategoryAPI.createRecordCategoryChild(newRecordFolderModel, recordCategoryId, "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)newRecordCategoryChild.getIsRecordCategory());
        Assert.assertFalse((boolean)newRecordCategoryChild.getIsRecordFolder());
        Assert.assertTrue((boolean)newRecordCategoryChild.getPath().getName().contains(newRelativePath));
        Assert.assertNotNull((Object)recordCategoryAPI.getRecordCategory(newRecordCategoryChild.getParentId()).getId());
        RecordCategory newRecordFolder = recordCategoryAPI.getRecordCategory(newRecordCategoryChild.getId(), "include=path");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)recordSubCategory.getNodeType(), (String)"rma:recordCategory");
        Assert.assertTrue((boolean)newRecordFolder.getPath().getName().contains(newRelativePath));
    }

    @Test(description="Create a record folder into transfers/unfiled/file plan container", dataProviderClass=DataProviderClass.class, dataProvider="getContainers")
    @Bug(id="RM-4327")
    public void createRecordFolderIntoSpecialContainers(String containerAlias) {
        String containerId = "-filePlan-".equalsIgnoreCase(containerAlias) ? this.getRestAPIFactory().getFilePlansAPI().getFilePlan(containerAlias).getId() : ("-transfers-".equalsIgnoreCase(containerAlias) ? this.getRestAPIFactory().getTransferContainerAPI().getTransferContainer(containerAlias).getId() : this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer(containerAlias).getId());
        this.createRecordFolder(containerId, TestData.RECORD_FOLDER_NAME);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }
}

