/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordCategoriesAPI;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.lang3.time.DateUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class RecordRetentionAsOfDateTest
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    @Autowired
    private RecordCategoriesAPI recordCategoriesAPI;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    private RecordCategory Category1;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(RecordRetentionAsOfDateTest.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private final String recordsCategory = this.TEST_PREFIX + "RM-5733 category";
    private final String folderDisposition = this.TEST_PREFIX + "RM-5733 folder";
    private static final String YEAR_MONTH_DAY = "yyyy-MM-dd";

    @Test
    @AlfrescoTest(jira="RM-5733,RM-5799")
    public void checkRetentionAsOfDateForTransferStepWithRetentionAction() {
        this.createTestPrecondition(this.recordsCategory);
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.Category1.getName(), Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffImmediatelyStep(this.Category1.getName());
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> transferStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, "day|1");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "transfer");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY, "rma:cutOffDate");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.COMBINE_DISPOSITION_STEP_CONDITIONS, "false");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_ELIGIBLE_FIRST_EVENT, "true");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_GHOST, "on");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Transfer after 1 day");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.Category1.getName(), transferStep);
        RecordCategoryChild FOLDER = this.createFolder(this.getAdminUser(), this.Category1.getId(), this.folderDisposition);
        String nonElectronicRecord = this.TEST_PREFIX + "RM-5733 non-electronic record";
        Record nonElRecord = this.createNonElectronicRecord(FOLDER.getId(), nonElectronicRecord);
        String nonElRecordName = this.recordsAPI.getRecordFullName(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.folderDisposition, nonElectronicRecord);
        this.completeRecord(nonElRecord.getId());
        String nonElRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecordName, "/" + this.Category1.getName() + "/" + this.folderDisposition);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), nonElRecordNameNodeRef);
        JSONObject nextDispositionActionJson = this.recordCategoriesAPI.getNextDispositionAction(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecord.getId());
        Assert.assertTrue((boolean)this.getAsOfDate(nextDispositionActionJson).startsWith(RecordRetentionAsOfDateTest.getTomorrow()), (String)"The retention as of date is not set to tomorrow.");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() {
        this.deleteRecordCategory(this.Category1.getId());
    }

    private void createTestPrecondition(String categoryName) {
        this.createRMSiteIfNotExists();
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.RM_ADMIN, "password", "Administrator");
        Step.STEP((String)"Create category");
        this.Category1 = this.createRootCategory(categoryName, "Title");
    }

    private String getAsOfDate(JSONObject nextDispositionActionJson) {
        return nextDispositionActionJson.getJSONObject("data").get("asOf").toString();
    }

    private static String getTomorrow() {
        Date today = new Date();
        Date tomorrow = DateUtils.addDays((Date)today, (int)1);
        SimpleDateFormat dateFormat = new SimpleDateFormat(YEAR_MONTH_DAY);
        return dateFormat.format(tomorrow);
    }
}

