/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.model.audit.AuditEntry;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.testng.Assert;

@Component
public class RMAuditAPI
extends BaseAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMAuditAPI.class);
    private static final String RM_AUDIT_API = "{0}rma/admin/rmauditlog";
    private static final String RM_AUDIT_LOG_API = "{0}rma/admin/rmauditlog?{1}";
    private static final String RM_AUDIT_LOG_AS_RECORD = "{0}node/{1}/rmauditlog";

    public List<AuditEntry> getRMAuditLog(String user, String password, int size, String event) {
        String parameters = null;
        try {
            parameters = "size=" + size + (String)(event != null ? "&event=" + URLEncoder.encode(event, "UTF-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unable to encode the event name {}", (Object)e.getMessage());
        }
        JSONArray auditEntries = this.doGetRequest(user, password, MessageFormat.format(RM_AUDIT_LOG_API, "{0}", parameters), new String[0]).getJSONObject("data").getJSONArray("entries");
        return PojoUtility.jsonToObject(auditEntries, AuditEntry.class);
    }

    public List<AuditEntry> getRMAuditLogAll(String user, String password, int size) {
        String parameters = "size=" + size;
        JSONArray auditEntries = this.doGetRequest(user, password, MessageFormat.format(RM_AUDIT_LOG_API, "{0}", parameters), new String[0]).getJSONObject("data").getJSONArray("entries");
        return PojoUtility.jsonToObject(auditEntries, AuditEntry.class);
    }

    public void clearAuditLog(String username, String password) {
        JSONObject deleteStatus = this.doDeleteRequest(username, password, RM_AUDIT_API, new String[0]);
        Assert.assertTrue((deleteStatus != null && this.getRMAuditLog(username, password, 100, null).size() == 2 ? 1 : 0) != 0);
    }

    public HttpResponse logsAuditLogAsRecord(String username, String password, String recNodeRef, String destinationNodeRef) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("destination", (Object)destinationNodeRef);
        return this.doPostJsonRequest(username, password, 200, requestParams, RM_AUDIT_LOG_AS_RECORD, recNodeRef);
    }
}

