/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.recordfolders;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RecordFolder;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="record-folders", title="Record Folders")
public class RecordFolderEntityResource
implements EntityResourceAction.ReadById<RecordFolder>,
EntityResourceAction.Delete,
EntityResourceAction.Update<RecordFolder>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get record folder information", description="Gets information for a record folder with id 'recordFolderId'")
    @WebApiParam(name="recordFolderId", title="The record folder id")
    public RecordFolder readById(String recordFolderId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createRecordFolder(info, parameters, null, false);
    }

    @WebApiDescription(title="Update record folder", description="Updates a record folder with id 'recordFolderId'")
    public RecordFolder update(String recordFolderId, final RecordFolder recordFolderInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"recordFolderInfo", (Object)recordFolderInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                RecordFolderEntityResource.this.apiUtils.updateNode(nodeRef, recordFolderInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return RecordFolderEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        return this.nodesModelFactory.createRecordFolder(info, parameters, null, false);
    }

    @WebApiDescription(title="Delete record folder", description="Deletes a record folder with id 'recordFolderId'")
    public void delete(String recordFolderId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordFolderId", recordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(recordFolderId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        this.fileFolderService.delete(nodeRef);
    }
}

