/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition.HoldCapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class HoldCapabilityConditionUnitTest
extends BaseUnitTest {
    private NodeRef hold1;
    private NodeRef hold2;
    private List<NodeRef> holds;
    @Mock(name="kinds")
    private Set<FilePlanComponentKind> mockedKinds;
    @Spy
    @InjectMocks
    private HoldCapabilityCondition evaluator;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.hold1 = this.generateNodeRef(TYPE_HOLD);
        this.hold2 = this.generateNodeRef(TYPE_HOLD);
        this.holds = new ArrayList<NodeRef>(2);
        this.holds.add(this.hold1);
        this.holds.add(this.hold2);
        ((Set)Mockito.doReturn((Object)false).when(this.mockedKinds)).contains(FilePlanComponentKind.RECORD_CATEGORY);
        ((Set)Mockito.doReturn((Object)true).when(this.mockedKinds)).contains(FilePlanComponentKind.RECORD_FOLDER);
        ((Set)Mockito.doReturn((Object)true).when(this.mockedKinds)).contains(FilePlanComponentKind.HOLD);
    }

    @Test
    public void noHolds() {
        ((HoldService)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.mockedHoldService)).heldBy((NodeRef)Matchers.eq((Object)this.recordFolder), Matchers.anyBoolean());
        boolean result = this.evaluator.evaluateImpl(this.recordFolder);
        Assert.assertFalse((boolean)result);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.never())).hasPermission((NodeRef)Matchers.any(NodeRef.class), (String)Matchers.eq((Object)"Filing"));
    }

    @Test
    public void noFillingOnHolds() {
        ((HoldService)Mockito.doReturn(this.holds).when((Object)this.mockedHoldService)).heldBy((NodeRef)Matchers.eq((Object)this.recordFolder), Matchers.anyBoolean());
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.DENIED).when((Object)this.mockedPermissionService)).hasPermission(this.hold1, "Filing");
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.DENIED).when((Object)this.mockedPermissionService)).hasPermission(this.hold2, "Filing");
        boolean result = this.evaluator.evaluateImpl(this.recordFolder);
        Assert.assertFalse((boolean)result);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)2))).hasPermission((NodeRef)Matchers.any(NodeRef.class), (String)Matchers.eq((Object)"Filing"));
    }

    @Test
    public void fillingOnHolds() {
        ((HoldService)Mockito.doReturn(this.holds).when((Object)this.mockedHoldService)).heldBy((NodeRef)Matchers.eq((Object)this.recordFolder), Matchers.anyBoolean());
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.DENIED).when((Object)this.mockedPermissionService)).hasPermission(this.hold1, "Filing");
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.ALLOWED).when((Object)this.mockedPermissionService)).hasPermission(this.hold2, "Filing");
        boolean result = this.evaluator.evaluateImpl(this.recordFolder);
        Assert.assertTrue((boolean)result);
        ((PermissionService)Mockito.verify((Object)this.mockedPermissionService, (VerificationMode)Mockito.times((int)2))).hasPermission((NodeRef)Matchers.any(NodeRef.class), (String)Matchers.eq((Object)"Filing"));
    }
}

