/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionResult;
import org.alfresco.module.org_alfresco_module_rm.report.Report;
import org.alfresco.module.org_alfresco_module_rm.report.ReportModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.apache.commons.lang3.StringUtils;

public class ReportServiceImplTest
extends BaseRMTestCase
implements ReportModel {
    public void testGetReportTypes() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Set reportTypes = ReportServiceImplTest.this.reportService.getReportTypes();
                TestCase.assertNotNull((Object)reportTypes);
                TestCase.assertFalse((boolean)reportTypes.isEmpty());
                for (QName reportType : reportTypes) {
                    System.out.println(reportType.toString());
                }
                return null;
            }
        });
    }

    public void testGenerateReport() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Report destructionReport = ReportServiceImplTest.this.generateDestructionReport();
                System.out.println(destructionReport.getReportName());
                System.out.println(destructionReport.getReportContent().getContentString());
                Report transferReport = ReportServiceImplTest.this.reportService.generateReport(ReportModel.TYPE_TRANSFER_REPORT, ReportServiceImplTest.this.getTransferObject(), "text/html");
                System.out.println(transferReport.getReportName());
                System.out.println(transferReport.getReportContent().getContentString());
                return null;
            }
        });
    }

    public void testFileReport() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef destructionReportNodeRef = ReportServiceImplTest.this.fileDestructionReport();
                TestCase.assertNotNull((Object)destructionReportNodeRef);
                TestCase.assertTrue((boolean)ReportServiceImplTest.this.recordService.isRecord(destructionReportNodeRef));
                TestCase.assertFalse((boolean)ReportServiceImplTest.this.recordService.isFiled(destructionReportNodeRef));
                TestCase.assertEquals((Object)ReportModel.TYPE_DESTRUCTION_REPORT, (Object)ReportServiceImplTest.this.nodeService.getType(destructionReportNodeRef));
                NodeRef transferReportNodeRef = ReportServiceImplTest.this.fileTransferReport();
                TestCase.assertNotNull((Object)transferReportNodeRef);
                TestCase.assertTrue((boolean)ReportServiceImplTest.this.recordService.isRecord(transferReportNodeRef));
                TestCase.assertFalse((boolean)ReportServiceImplTest.this.recordService.isFiled(transferReportNodeRef));
                TestCase.assertEquals((Object)ReportModel.TYPE_TRANSFER_REPORT, (Object)ReportServiceImplTest.this.nodeService.getType(transferReportNodeRef));
                return null;
            }
        });
    }

    private Report generateDestructionReport() {
        return this.reportService.generateReport(TYPE_DESTRUCTION_REPORT, this.rmFolder);
    }

    private NodeRef fileDestructionReport() {
        Report destructionReport = this.generateDestructionReport();
        return this.reportService.fileReport(this.filePlan, destructionReport);
    }

    private NodeRef fileTransferReport() {
        Report transferReport = this.reportService.generateReport(TYPE_TRANSFER_REPORT, this.getTransferObject(), "text/html");
        return this.reportService.fileReport(this.filePlan, transferReport);
    }

    public void testFileDestructionReportAction() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                ReportServiceImplTest.this.rmActionService.executeRecordsManagementAction(ReportServiceImplTest.this.rmFolder, "completeEvent", params);
                ReportServiceImplTest.this.rmActionService.executeRecordsManagementAction(ReportServiceImplTest.this.rmFolder, "cutoff");
                ReportServiceImplTest.this.rmActionService.executeRecordsManagementAction(ReportServiceImplTest.this.rmFolder, "destroy");
                HashMap<String, String> fileReportParams = new HashMap<String, String>(2);
                fileReportParams.put("reportType", "rmr:destructionReport");
                fileReportParams.put("destination", ReportServiceImplTest.this.filePlan.toString());
                ReportServiceImplTest.this.rmActionService.executeRecordsManagementAction(ReportServiceImplTest.this.rmFolder, "fileReport", fileReportParams);
                return null;
            }
        });
    }

    public void testFileTransferReportAction() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(2);
                params.put("reportType", "rmr:transferReport");
                params.put("destination", ReportServiceImplTest.this.filePlan.toString());
                RecordsManagementActionResult transferReportAction = ReportServiceImplTest.this.rmActionService.executeRecordsManagementAction(ReportServiceImplTest.this.getTransferObject(), "fileReport", params);
                String transferReportName = (String)transferReportAction.getValue();
                TestCase.assertFalse((boolean)StringUtils.isBlank((CharSequence)transferReportName));
                return null;
            }
        });
    }

    private NodeRef getTransferObject() {
        NodeRef recordCategory = this.filePlanService.createRecordCategory(this.filePlan, GUID.generate());
        this.utils.createDispositionSchedule(recordCategory, "disposition instructions", "disposition authority", false, true, true);
        NodeRef recordFolder = this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
        String identifier = this.identifierService.generateIdentifier(TYPE_RECORD_FOLDER, recordCategory);
        this.nodeService.setProperty(recordFolder, PROP_IDENTIFIER, (Serializable)((Object)identifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("eventName", "case_closed");
        this.rmActionService.executeRecordsManagementAction(recordFolder, "completeEvent", params);
        this.rmActionService.executeRecordsManagementAction(recordFolder, "cutoff");
        RecordsManagementActionResult transferAction = this.rmActionService.executeRecordsManagementAction(recordFolder, "transfer");
        NodeRef transferObject = (NodeRef)transferAction.getValue();
        ReportServiceImplTest.assertTrue((transferObject != null ? 1 : 0) != 0);
        return transferObject;
    }
}

