/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content;

import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.module.org_alfresco_module_rm.content.EagerContentStoreCleaner;
import org.alfresco.module.org_alfresco_module_rm.util.ContentBinDuplicationUtility;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

@BehaviourBean
public class ContentDestructionComponent {
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private ContentBinDuplicationUtility contentBinDuplicationUtility;
    private boolean cleansingEnabled = false;

    protected EagerContentStoreCleaner getEagerContentStoreCleaner() {
        return this.eagerContentStoreCleaner;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    protected BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    public boolean isCleansingEnabled() {
        return this.cleansingEnabled;
    }

    public void setEagerContentStoreCleaner(EagerContentStoreCleaner eagerContentStoreCleaner) {
        this.eagerContentStoreCleaner = eagerContentStoreCleaner;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setContentBinDuplicationUtility(ContentBinDuplicationUtility contentBinDuplicationUtility) {
        this.contentBinDuplicationUtility = contentBinDuplicationUtility;
    }

    public void setCleansingEnabled(boolean cleansingEnabled) {
        this.cleansingEnabled = cleansingEnabled;
    }

    public void destroyContent(NodeRef nodeRef) {
        this.destroyContent(nodeRef, true);
    }

    public void destroyContent(NodeRef nodeRef, boolean includeRenditions) {
        this.registerAllContentForDestruction(nodeRef, true);
        if (includeRenditions && (this.getNodeService().hasAspect(nodeRef, RenditionModel.ASPECT_RENDITIONED) || this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_THUMBNAILED))) {
            Set childAssocTypes = this.dictionaryService.getAspect(RenditionModel.ASPECT_RENDITIONED).getChildAssociations().keySet();
            for (ChildAssociationRef child : this.getNodeService().getChildAssocs(nodeRef)) {
                if (!childAssocTypes.contains(child.getTypeQName())) continue;
                this.destroyContent(child.getChildRef(), false);
                this.getNodeService().deleteNode(child.getChildRef());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllContentForDestruction(NodeRef nodeRef, boolean clearContentProperty) {
        Map properties = this.getNodeService().getProperties(nodeRef);
        for (Map.Entry entry : properties.entrySet()) {
            if (!(entry.getValue() instanceof ContentData)) continue;
            ContentData dataContent = (ContentData)entry.getValue();
            if (!this.contentBinDuplicationUtility.hasAtLeastOneOtherReference(nodeRef)) {
                if (this.isCleansingEnabled()) {
                    this.getEagerContentStoreCleaner().registerOrphanedContentUrlForCleansing(dataContent.getContentUrl());
                } else {
                    this.getEagerContentStoreCleaner().registerOrphanedContentUrl(dataContent.getContentUrl(), true);
                }
            }
            if (!clearContentProperty) continue;
            this.behaviourFilter.disableBehaviour();
            try {
                this.getNodeService().removeProperty(nodeRef, (QName)entry.getKey());
            }
            finally {
                this.behaviourFilter.enableBehaviour();
            }
        }
    }
}

