/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RMDispositionActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;

public class CutOffAction
extends RMDispositionActionExecuterAbstractBase {
    public static final String NAME = "cutoff";

    @Override
    protected void executeRecordFolderLevelDisposition(Action action, NodeRef recordFolder) {
        if (this.checkUncutOffStatus(action, recordFolder)) {
            this.getDispositionService().cutoffDisposableItem(recordFolder);
        }
    }

    @Override
    protected void executeRecordLevelDisposition(Action action, NodeRef record) {
        if (this.checkUncutOffStatus(action, record)) {
            this.getDispositionService().cutoffDisposableItem(record);
        }
    }

    private boolean checkUncutOffStatus(Action action, NodeRef recordOrFolder) {
        boolean okToCutOff = true;
        if (this.getNodeService().hasAspect(recordOrFolder, ASPECT_UNCUT_OFF)) {
            if (action.getParameterValue("rm.no-error-check") != null) {
                throw new AlfrescoRuntimeException("Cannot cut off from schedule when uncut off aspect is present");
            }
            this.getNodeService().removeAspect(recordOrFolder, ASPECT_UNCUT_OFF);
        }
        return okToCutOff;
    }
}

