/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RecordMetaDataAspectsGet
extends DeclarativeWebScript {
    private static final String PARAM_NODEREF = "noderef";
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected RecordService recordService;
    protected FilePlanService filePlanService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef nodeRef = null;
        String nodeRefValue = req.getParameter(PARAM_NODEREF);
        nodeRef = nodeRefValue == null || nodeRefValue.trim().length() == 0 ? this.filePlanService.getFilePlanBySiteId("rm") : new NodeRef(nodeRefValue);
        Set<QName> aspectQNames = this.recordService.getRecordMetadataAspects(nodeRef);
        ArrayList aspects = new ArrayList(aspectQNames.size() + 1);
        for (QName aspectQName : aspectQNames) {
            String prefixString = aspectQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            String label = aspectQName.getLocalName();
            HashMap<String, String> aspect = new HashMap<String, String>(2);
            aspect.put("id", prefixString);
            AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspectQName);
            if (aspectDefinition != null) {
                label = aspectDefinition.getTitle((MessageLookup)this.dictionaryService);
            }
            aspect.put("value", label);
            aspects.add(aspect);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("aspects", aspects);
        return model;
    }
}

