/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.sites;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.RMSites;
import org.alfresco.rm.rest.api.model.RMSite;

@EntityResource(name="gs-sites", title="GS Sites")
public class RMSiteEntityResource
implements EntityResourceAction.Delete,
EntityResourceAction.Create<RMSite>,
EntityResourceAction.Update<RMSite>,
EntityResourceAction.ReadById<RMSite> {
    private static final String RM_SITE_ID = "rm";
    private RMSites sites;
    private String PARAM_PERMANENT = "permanent";

    public void setSites(RMSites sites) {
        this.sites = sites;
    }

    public List<RMSite> create(List<RMSite> entity, Parameters parameters) {
        ArrayList<RMSite> result = new ArrayList<RMSite>(1);
        result.add(this.sites.createRMSite(entity.get(0), parameters));
        return result;
    }

    public void delete(String siteId, Parameters parameters) {
        if (!RM_SITE_ID.equals(siteId)) {
            throw new InvalidParameterException("The Deletion is supported only for siteId = rm.");
        }
        String permanentParameter = parameters.getParameter(this.PARAM_PERMANENT);
        if (permanentParameter != null) {
            throw new InvalidArgumentException("DELETE does not support parameter: permanent");
        }
        this.sites.deleteRMSite(siteId, parameters);
    }

    public RMSite update(String siteId, RMSite site, Parameters parameters) {
        if (!RM_SITE_ID.equals(siteId)) {
            throw new InvalidParameterException("The Update is supported only for siteId = rm.");
        }
        return this.sites.updateRMSite(siteId, this.convert(site), parameters);
    }

    public RMSite readById(String siteId, Parameters parameters) {
        if (!RM_SITE_ID.equals(siteId)) {
            throw new InvalidParameterException("GET is supported only for siteId = rm.");
        }
        return this.sites.getRMSite(siteId);
    }

    protected SiteUpdate convert(RMSite site) {
        if (site.wasSet("id")) {
            throw new InvalidArgumentException("Site update does not support field: id");
        }
        if (site.wasSet("guid")) {
            throw new InvalidArgumentException("Site update does not support field: guid");
        }
        if (site.wasSet("role")) {
            throw new InvalidArgumentException("Site update does not support field: role");
        }
        if (site.wasSet("preset")) {
            throw new InvalidArgumentException("Site update does not support field: preset");
        }
        if (site.wasSet("compliance")) {
            throw new InvalidArgumentException("Site update does not support field: compliance");
        }
        if (site.wasSet("visibility")) {
            throw new InvalidArgumentException("Site update does not support field: visibility");
        }
        SiteUpdate siteUpdate = new SiteUpdate();
        if (site.wasSet("title")) {
            siteUpdate.setTitle(site.getTitle());
        }
        if (site.wasSet("description")) {
            siteUpdate.setDescription(site.getDescription());
        }
        return siteUpdate;
    }
}

