/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class ExtendedActionServiceTest
extends BaseRMTestCase {
    public static final String TEST_ACTION = "testAction";
    public static final String TEST_ACTION_2 = "testAction2";
    public static final String TEST_DM_ACTION = "testDMAction";
    public static final String RECORD_ONLY_ACTION = "recordOnlyAction";
    public static final String RECORD_AND_FOLDER_ONLY_ACTION = "recordandFolderOnlyAction";
    public static final String DELEGATE_ACTION = "rmDelegateAction";

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void xtestAvailableActions() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List result = ExtendedActionServiceTest.this.actionService.getActionDefinitions(ExtendedActionServiceTest.this.recordOne);
                TestCase.assertNotNull((Object)result);
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION_2));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_DM_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_ONLY_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_AND_FOLDER_ONLY_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.DELEGATE_ACTION));
                result = ExtendedActionServiceTest.this.actionService.getActionDefinitions(ExtendedActionServiceTest.this.rmFolder);
                TestCase.assertNotNull((Object)result);
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION_2));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_DM_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_ONLY_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_AND_FOLDER_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.DELEGATE_ACTION));
                result = ExtendedActionServiceTest.this.actionService.getActionDefinitions(ExtendedActionServiceTest.this.rmContainer);
                TestCase.assertNotNull((Object)result);
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION_2));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_DM_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_AND_FOLDER_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.DELEGATE_ACTION));
                result = ExtendedActionServiceTest.this.actionService.getActionDefinitions(ExtendedActionServiceTest.this.dmDocument);
                TestCase.assertNotNull((Object)result);
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION_2));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_DM_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_AND_FOLDER_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.DELEGATE_ACTION));
                result = ExtendedActionServiceTest.this.actionService.getActionDefinitions(ExtendedActionServiceTest.this.dmFolder);
                TestCase.assertNotNull((Object)result);
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_ACTION_2));
                TestCase.assertTrue((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.TEST_DM_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.RECORD_AND_FOLDER_ONLY_ACTION));
                TestCase.assertFalse((boolean)ExtendedActionServiceTest.this.containsAction(result, ExtendedActionServiceTest.DELEGATE_ACTION));
                return null;
            }
        });
    }

    private boolean containsAction(List<ActionDefinition> list, String actionName) {
        boolean result = false;
        for (ActionDefinition actionDefinition : list) {
            if (!actionDefinition.getName().equals(actionName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void testActionPropertySubstitution() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Action action = ExtendedActionServiceTest.this.actionService.createAction("testActionPropertySubs");
                action.setParameterValue("dayShort", (Serializable)((Object)"${date.day.short}"));
                action.setParameterValue("dayShort2", (Serializable)((Object)"${date.day}"));
                action.setParameterValue("dayLong", (Serializable)((Object)"${date.day.long}"));
                action.setParameterValue("dayNumber", (Serializable)((Object)"${date.day.number}"));
                action.setParameterValue("dayYear", (Serializable)((Object)"${date.day.year}"));
                action.setParameterValue("monthShort", (Serializable)((Object)"${date.month.short}"));
                action.setParameterValue("monthShort2", (Serializable)((Object)"${date.month}"));
                action.setParameterValue("monthLong", (Serializable)((Object)"${date.month.long}"));
                action.setParameterValue("monthNumber", (Serializable)((Object)"${date.month.number}"));
                action.setParameterValue("yearShort", (Serializable)((Object)"${date.year.short}"));
                action.setParameterValue("yearShort2", (Serializable)((Object)"${date.year}"));
                action.setParameterValue("yearLong", (Serializable)((Object)"${date.year.long}"));
                action.setParameterValue("yearWeek", (Serializable)((Object)"${date.year.week}"));
                action.setParameterValue("name", (Serializable)((Object)"${node.cm:name}"));
                action.setParameterValue("company", (Serializable)((Object)"${message.test.company}"));
                action.setParameterValue("combo", (Serializable)((Object)"${date.year.long}/${date.month.short}/${node.cm:name}-${message.test.company}.txt"));
                ExtendedActionServiceTest.this.actionService.executeAction(action, ExtendedActionServiceTest.this.rmFolder);
                return null;
            }
        });
    }

    public void testDelegateActions() {
        ExtendedActionServiceTest.assertTrue((boolean)this.inheritsAllParameterDefinitions("setPropertyValue", "set-property-value"));
        ExtendedActionServiceTest.assertTrue((boolean)this.inheritsAllParameterDefinitions("executeScript", "rmscript"));
        ExtendedActionServiceTest.assertTrue((boolean)this.inheritsAllParameterDefinitions("sendEmail", "mail"));
    }

    private boolean inheritsAllParameterDefinitions(String rmAction, String delegateAction) {
        ActionDefinition rmActionDefinition = this.actionService.getActionDefinition(rmAction);
        ExtendedActionServiceTest.assertNotNull((Object)rmActionDefinition);
        List rmParameterDefinitions = rmActionDefinition.getParameterDefinitions();
        ActionDefinition delegateActionDefinition = this.actionService.getActionDefinition(delegateAction);
        ExtendedActionServiceTest.assertNotNull((Object)delegateActionDefinition);
        List delegateParameterDefinitions = delegateActionDefinition.getParameterDefinitions();
        return rmParameterDefinitions.containsAll(delegateParameterDefinitions);
    }
}

