/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.UnfiledRecordFolderType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class UnfiledRecordFolderTypeUnitTest
extends BaseUnitTest {
    @InjectMocks
    private UnfiledRecordFolderType unfiledRecordFolderType;

    @Test(expected=IntegrityException.class)
    public void testAddNonAcceptedTypeToUnfiledRecordFolder() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordFolder = this.generateNodeRef(TYPE_UNFILED_RECORD_FOLDER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordFolder);
        this.unfiledRecordFolderType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddUnfiledRecordFolderTypeToUnfiledRecordFolder() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordFolder = this.generateNodeRef(TYPE_UNFILED_RECORD_FOLDER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordFolder);
        this.unfiledRecordFolderType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddContentTypeToUnfiledRecordFolder() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordFolder = this.generateNodeRef(TYPE_UNFILED_RECORD_FOLDER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordFolder);
        this.unfiledRecordFolderType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testNonElectronicDocumentTypeToUnfiledRecordFolder() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordFolder = this.generateNodeRef(TYPE_UNFILED_RECORD_FOLDER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordFolder);
        this.unfiledRecordFolderType.onCreateChildAssociation(mockedChildAssoc, true);
    }
}

