/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.integration.version.RecordableVersionsBaseTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class DeclareAsRecordVersionTest
extends RecordableVersionsBaseTest {
    private RecordableVersionService recordableVersionService;

    @Override
    protected void initServices() {
        super.initServices();
        this.recordableVersionService = (RecordableVersionService)this.applicationContext.getBean("RecordableVersionService");
    }

    public void testDeclareLatestVersionAsRecord() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef versionRecord;
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                DeclareAsRecordVersionTest.this.nodeService.removeProperty(DeclareAsRecordVersionTest.this.dmDocument, ContentModel.PROP_CONTENT);
                DeclareAsRecordVersionTest.this.versionService.createVersion(DeclareAsRecordVersionTest.this.dmDocument, this.versionProperties);
                TestCase.assertFalse((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(DeclareAsRecordVersionTest.this.dmDocument));
            }

            @Override
            public void when() {
                this.versionRecord = DeclareAsRecordVersionTest.this.recordableVersionService.createRecordFromLatestVersion(DeclareAsRecordVersionTest.this.filePlan, DeclareAsRecordVersionTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.versionRecord);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordService.isRecord(this.versionRecord));
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(DeclareAsRecordVersionTest.this.dmDocument));
                DeclareAsRecordVersionTest.this.checkRecordedVersion(DeclareAsRecordVersionTest.this.dmDocument, "description", "0.1");
            }
        });
    }

    public void testDeclareLatestVersionAsRecordButAlreadyRecorded() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef versionRecord;
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.versionProperties = new HashMap<String, Serializable>(4);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                this.versionProperties.put("recordable-version", Boolean.valueOf(true));
                this.versionProperties.put("file-plan", (Serializable)DeclareAsRecordVersionTest.this.filePlan);
                DeclareAsRecordVersionTest.this.versionService.createVersion(DeclareAsRecordVersionTest.this.dmDocument, this.versionProperties);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(DeclareAsRecordVersionTest.this.dmDocument));
            }

            @Override
            public void when() {
                this.versionRecord = DeclareAsRecordVersionTest.this.recordableVersionService.createRecordFromLatestVersion(DeclareAsRecordVersionTest.this.filePlan, DeclareAsRecordVersionTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertNull((Object)this.versionRecord);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(DeclareAsRecordVersionTest.this.dmDocument));
                DeclareAsRecordVersionTest.this.checkRecordedVersion(DeclareAsRecordVersionTest.this.dmDocument, "description", "0.1");
            }
        });
    }

    public void testSpecializedContentType() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef customDocument;
            private NodeRef versionRecord;
            private Map<String, Serializable> versionProperties;

            @Override
            public void given() throws Exception {
                this.customDocument = DeclareAsRecordVersionTest.this.fileFolderService.create(DeclareAsRecordVersionTest.this.dmFolder, GUID.generate(), DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE).getNodeRef();
                DeclareAsRecordVersionTest.this.prepareContent(this.customDocument);
                this.versionProperties = new HashMap<String, Serializable>(2);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
                DeclareAsRecordVersionTest.this.nodeService.removeProperty(this.customDocument, ContentModel.PROP_CONTENT);
                DeclareAsRecordVersionTest.this.versionService.createVersion(this.customDocument, this.versionProperties);
                TestCase.assertFalse((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(this.customDocument));
            }

            @Override
            public void when() {
                this.versionRecord = DeclareAsRecordVersionTest.this.recordableVersionService.createRecordFromLatestVersion(DeclareAsRecordVersionTest.this.filePlan, this.customDocument);
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.versionRecord);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordService.isRecord(this.versionRecord));
                TestCase.assertEquals((Object)DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE, (Object)DeclareAsRecordVersionTest.this.nodeService.getType(this.versionRecord));
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(this.customDocument));
                DeclareAsRecordVersionTest.this.checkRecordedVersion(this.customDocument, "description", "0.1");
            }
        });
    }

    public void testCreateRecordFromLatestVersionAutoTrue() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef myDocument;
            private NodeRef versionedRecord;
            private Map<String, Serializable> versionProperties;
            private Date createdDate;
            private Date modificationDate;
            private String record_name;
            private String AUTO_VERSION_DESCRIPTION;
            private boolean autoVersion;
            {
                this.record_name = "initial_name";
                this.AUTO_VERSION_DESCRIPTION = "Auto Version on Record Creation";
                this.autoVersion = true;
            }

            @Override
            public void given() throws Exception {
                this.myDocument = DeclareAsRecordVersionTest.this.fileFolderService.create(DeclareAsRecordVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                this.createdDate = (Date)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_CREATED);
                this.modificationDate = (Date)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_MODIFIED);
                TestCase.assertTrue((String)"Modified date must be after or on creation date", (this.createdDate.getTime() == this.modificationDate.getTime() ? 1 : 0) != 0);
                HashMap<QName, Object> properties = new HashMap<QName, Object>(3);
                properties.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
                properties.put(ContentModel.PROP_NAME, "initial_name");
                DeclareAsRecordVersionTest.this.nodeService.setProperties(this.myDocument, properties);
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description"));
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_OWNABLE, null);
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, null);
                DeclareAsRecordVersionTest.this.nodeService.setType(this.myDocument, DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE);
                this.versionProperties = new HashMap<String, Serializable>(2);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
                DeclareAsRecordVersionTest.this.versionService.createVersion(this.myDocument, this.versionProperties);
            }

            @Override
            public void when() {
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_TITLED, null);
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_NAME, (Serializable)((Object)"updated_name"));
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description"));
                this.versionedRecord = DeclareAsRecordVersionTest.this.recordableVersionService.createRecordFromLatestVersion(DeclareAsRecordVersionTest.this.filePlan, this.myDocument, this.autoVersion);
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.versionedRecord);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordService.isRecord(this.versionedRecord));
                TestCase.assertEquals((Object)DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE, (Object)DeclareAsRecordVersionTest.this.nodeService.getType(this.versionedRecord));
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(this.myDocument));
                this.record_name = (String)((Object)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.versionedRecord, ContentModel.PROP_NAME));
                TestCase.assertTrue((String)"Name was updated:", (boolean)this.record_name.contains("updated_name"));
                DeclareAsRecordVersionTest.this.checkRecordedVersion(this.myDocument, this.AUTO_VERSION_DESCRIPTION, "1.1");
            }
        });
    }

    public void testCreateRecordFromLatestVersion() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.dmCollaborator){
            private NodeRef myDocument;
            private NodeRef versionedRecord;
            private Map<String, Serializable> versionProperties;
            private Date createdDate;
            private Date modificationDate;
            private String record_name;
            private boolean autoVersion;
            {
                this.record_name = "initial_name";
                this.autoVersion = false;
            }

            @Override
            public void given() throws Exception {
                this.myDocument = DeclareAsRecordVersionTest.this.fileFolderService.create(DeclareAsRecordVersionTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                this.createdDate = (Date)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_CREATED);
                this.modificationDate = (Date)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.myDocument, ContentModel.PROP_MODIFIED);
                TestCase.assertTrue((String)"Modified date must be after or on creation date", (this.createdDate.getTime() == this.modificationDate.getTime() ? 1 : 0) != 0);
                HashMap<QName, Object> properties = new HashMap<QName, Object>(3);
                properties.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
                properties.put(ContentModel.PROP_NAME, "initial_name");
                DeclareAsRecordVersionTest.this.nodeService.setProperties(this.myDocument, properties);
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description"));
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_OWNABLE, null);
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_VERSIONABLE, null);
                DeclareAsRecordVersionTest.this.nodeService.setType(this.myDocument, DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE);
                this.versionProperties = new HashMap<String, Serializable>(2);
                this.versionProperties.put("description", (Serializable)((Object)"description"));
                this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
                DeclareAsRecordVersionTest.this.versionService.createVersion(this.myDocument, this.versionProperties);
            }

            @Override
            public void when() {
                DeclareAsRecordVersionTest.this.nodeService.addAspect(this.myDocument, ContentModel.ASPECT_TITLED, null);
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_NAME, (Serializable)((Object)"initial_name"));
                DeclareAsRecordVersionTest.this.nodeService.setProperty(this.myDocument, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description"));
                this.versionedRecord = DeclareAsRecordVersionTest.this.recordableVersionService.createRecordFromLatestVersion(DeclareAsRecordVersionTest.this.filePlan, this.myDocument, this.autoVersion);
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.versionedRecord);
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordService.isRecord(this.versionedRecord));
                TestCase.assertEquals((Object)DeclareAsRecordVersionTest.this.TYPE_CUSTOM_TYPE, (Object)DeclareAsRecordVersionTest.this.nodeService.getType(this.versionedRecord));
                TestCase.assertTrue((boolean)DeclareAsRecordVersionTest.this.recordableVersionService.isCurrentVersionRecorded(this.myDocument));
                this.record_name = (String)((Object)DeclareAsRecordVersionTest.this.nodeService.getProperty(this.versionedRecord, ContentModel.PROP_NAME));
                TestCase.assertTrue((String)"Name is not modified: ", (boolean)this.record_name.contains("initial_name"));
                DeclareAsRecordVersionTest.this.checkRecordedVersion(this.myDocument, "description", "1.0");
            }
        });
    }
}

