/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.util.Collections;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RMDispositionActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.content.ContentDestructionComponent;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.record.InplaceRecordService;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.version.Version;
import org.apache.commons.lang3.StringUtils;

public class DestroyAction
extends RMDispositionActionExecuterAbstractBase {
    public static final String NAME = "destroy";
    private ContentDestructionComponent contentDestructionComponent;
    private CapabilityService capabilityService;
    private RecordableVersionService recordableVersionService;
    private InplaceRecordService inplaceRecordService;
    private boolean ghostingEnabled = true;

    public void setContentDestructionComponent(ContentDestructionComponent contentDestructionComponent) {
        this.contentDestructionComponent = contentDestructionComponent;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setRecordableVersionService(RecordableVersionService recordableVersionService) {
        this.recordableVersionService = recordableVersionService;
    }

    public void setInplaceRecordService(InplaceRecordService inplaceRecordService) {
        this.inplaceRecordService = inplaceRecordService;
    }

    public void setGhostingEnabled(boolean ghostingEnabled) {
        this.ghostingEnabled = ghostingEnabled;
    }

    @Override
    protected boolean checkNextDispositionAction(NodeRef actionedUponNodeRef) {
        return this.checkForDestroyRecordsCapability(actionedUponNodeRef);
    }

    @Override
    protected boolean checkEligibility(NodeRef actionedUponNodeRef) {
        return this.checkForDestroyRecordsCapability(actionedUponNodeRef);
    }

    private boolean checkForDestroyRecordsCapability(NodeRef actionedUponNodeRef) {
        boolean result = true;
        if (AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapability("DestroyRecords").hasPermission(actionedUponNodeRef))) {
            result = false;
        }
        return result;
    }

    @Override
    protected void executeRecordFolderLevelDisposition(Action action, NodeRef recordFolder) {
        List<NodeRef> records = this.getRecordService().getRecords(recordFolder);
        for (NodeRef record : records) {
            this.executeRecordLevelDisposition(action, record);
        }
        if (this.isGhostOnDestroySetForAction(action, recordFolder)) {
            this.getNodeService().addAspect(recordFolder, ASPECT_GHOSTED, Collections.emptyMap());
        } else {
            this.getNodeService().deleteNode(recordFolder);
        }
    }

    @Override
    protected void executeRecordLevelDisposition(Action action, NodeRef record) {
        if (this.isGhostOnDestroySetForAction(action, record)) {
            Version version = this.recordableVersionService.getRecordedVersion(record);
            if (version != null) {
                this.recordableVersionService.destroyRecordedVersion(version);
            }
            this.inplaceRecordService.hideRecord(record);
            this.getNodeService().addAspect(record, ASPECT_GHOSTED, null);
            this.contentDestructionComponent.destroyContent(record);
        } else {
            this.getNodeService().deleteNode(record);
        }
    }

    private boolean isGhostOnDestroySetForAction(Action action, NodeRef nodeRef) {
        String ghostOnDestroyProperty;
        DispositionActionDefinition actionDefinition;
        DispositionSchedule dispositionSchedule;
        boolean ghostOnDestroy = this.ghostingEnabled;
        String actionDefinitionName = action.getActionDefinitionName();
        if (!StringUtils.isEmpty((CharSequence)actionDefinitionName) && (dispositionSchedule = this.getDispositionService().getDispositionSchedule(nodeRef)) != null && (actionDefinition = dispositionSchedule.getDispositionActionDefinitionByName(actionDefinitionName)) != null && (ghostOnDestroyProperty = actionDefinition.getGhostOnDestroy()) != null) {
            ghostOnDestroy = "ghost".equals(actionDefinition.getGhostOnDestroy());
        }
        return ghostOnDestroy;
    }
}

