/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.BaseActionUnitTest;
import org.alfresco.module.org_alfresco_module_rm.action.impl.UnlinkFromAction;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UnlinkFromActionUnitTest
extends BaseActionUnitTest {
    private NodeRef record;
    private NodeRef recordFolder;
    @InjectMocks
    private UnlinkFromAction action;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.record = this.generateRecord();
        this.recordFolder = this.generateRecordFolder();
    }

    @Test
    public void nodeDoesNotExist() {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).exists(this.record);
        this.action.executeImpl((Action)Mockito.mock(Action.class), this.record);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).unlink((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test
    public void nodePendingDelete() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.record);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_PENDING_DELETE);
        this.action.executeImpl((Action)Mockito.mock(Action.class), this.record);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).unlink((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test
    public void nodeNotRecord() {
        NodeRef notRecord = this.generateCmContent(AlfMock.generateText());
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(notRecord);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(notRecord, ASPECT_PENDING_DELETE);
        this.action.executeImpl((Action)Mockito.mock(Action.class), notRecord);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).unlink((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void recordFolderParamMissing() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.record);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_PENDING_DELETE);
        this.mockActionParameterValue("recordFolder", null);
        this.action.executeImpl(this.getMockedAction(), this.record);
    }

    @Test
    public void validUnlink() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.record);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.record, ASPECT_PENDING_DELETE);
        this.mockActionParameterValue("recordFolder", this.recordFolder.toString());
        this.action.executeImpl(this.getMockedAction(), this.record);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).unlink(this.record, this.recordFolder);
    }
}

