/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditEntry;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditQueryParameters;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.capability.RMPermissionModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.junit.Test;

public class RecordsManagementAuditServiceImplTest
extends BaseRMTestCase
implements RMPermissionModel {
    private static final QName HOLD_NAME = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Hold Name");
    private NodeRef record;
    private Date testStartTime;
    private static final String REMOVE_FROM_HOLD_AUDIT_EVENT = "Remove From Hold";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                RecordsManagementAuditServiceImplTest.this.testStartTime = new Date();
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.startAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                TestCase.assertTrue((boolean)RecordsManagementAuditServiceImplTest.this.rmAuditService.isAuditLogEnabled(RecordsManagementAuditServiceImplTest.this.filePlan));
                return null;
            }
        });
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "AuditTest.txt");
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        for (String user : this.testUsers) {
            this.filePlanPermissionService.setPermission(filePlan, user, "Filing");
            this.filePlanPermissionService.setPermission(this.rmContainer, user, "Filing");
        }
    }

    public void testGetAuditEvents() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                List events = RecordsManagementAuditServiceImplTest.this.rmAuditService.getAuditEvents();
                System.out.println("Found audit events:");
                for (AuditEvent event : events) {
                    System.out.println("  - " + event.getName() + " (" + event.getLabel() + ")");
                }
                return null;
            }
        }, "admin");
    }

    public void testGetAuditTrailForDeletedItem() {
        List<RecordsManagementAuditEntry> entries = this.getAuditTrail(1, "admin");
        RecordsManagementAuditServiceImplTest.assertEquals((String)entries.get(0).getEvent(), (String)"audit.start");
        this.updateTitle(this.filePlan, "admin");
        entries = this.getAuditTrail(3, "admin");
        RecordsManagementAuditServiceImplTest.assertEquals((String)entries.get(2).getEvent(), (String)"audit.start");
        RecordsManagementAuditServiceImplTest.assertEquals((String)entries.get(1).getEvent(), (String)"audit.view");
        RecordsManagementAuditServiceImplTest.assertEquals((String)entries.get(0).getEvent(), (String)"Update RM Object");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                RecordsManagementAuditServiceImplTest.this.nodeService.deleteNode(RecordsManagementAuditServiceImplTest.this.record);
                List<RecordsManagementAuditEntry> entries = RecordsManagementAuditServiceImplTest.this.getAuditTrail(5, "admin");
                TestCase.assertEquals((String)entries.get(4).getEvent(), (String)"audit.start");
                TestCase.assertEquals((String)entries.get(3).getEvent(), (String)"audit.view");
                TestCase.assertEquals((String)entries.get(2).getEvent(), (String)"Update RM Object");
                TestCase.assertEquals((String)entries.get(1).getEvent(), (String)"audit.view");
                TestCase.assertEquals((String)entries.get(0).getEvent(), (String)"Delete RM Object");
                TestCase.assertEquals((Object)entries.get(0).getNodeRef(), (Object)RecordsManagementAuditServiceImplTest.this.record);
                return null;
            }
        });
    }

    public void testGetAuditTrail() {
        this.getAuditTrail(1, "admin");
        final String updatedProperty = this.updateTitle(this.filePlan, "admin");
        List<RecordsManagementAuditEntry> entries = this.getAuditTrail(3, "admin");
        final RecordsManagementAuditEntry entry = entries.get(0);
        RecordsManagementAuditServiceImplTest.assertNotNull((Object)entry);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertEquals((Object)RecordsManagementAuditServiceImplTest.this.filePlan, (Object)entry.getNodeRef());
                String id = (String)((Object)RecordsManagementAuditServiceImplTest.this.nodeService.getProperty(RecordsManagementAuditServiceImplTest.this.filePlan, RecordsManagementModel.PROP_IDENTIFIER));
                TestCase.assertEquals((String)id, (String)entry.getIdentifier());
                Map after = entry.getAfterProperties();
                Map changed = entry.getChangedProperties();
                TestCase.assertTrue((boolean)after.containsKey(ContentModel.PROP_TITLE));
                TestCase.assertTrue((boolean)changed.containsKey(ContentModel.PROP_TITLE));
                Serializable value = (Serializable)((Map)after.get(ContentModel.PROP_TITLE)).get(Locale.ENGLISH);
                TestCase.assertEquals((Object)updatedProperty, (Object)value);
                value = (Serializable)((Map)((Pair)changed.get(ContentModel.PROP_TITLE)).getSecond()).get(Locale.ENGLISH);
                TestCase.assertEquals((Object)updatedProperty, (Object)value);
                return null;
            }
        }, "admin");
        this.updateTitle(this.rmContainer, "admin");
        this.updateTitle(this.rmFolder, "admin");
        this.updateTitle(this.record, "admin");
        this.getAuditTrail(7, "admin");
        Date snapShot = new Date();
        RecordsManagementAuditQueryParameters params = new RecordsManagementAuditQueryParameters();
        params.setMaxEntries(2);
        this.getAuditTrail(params, 2, "admin");
        this.updateTitle(this.rmContainer, this.recordsManagerName);
        this.updateTitle(this.rmFolder, this.recordsManagerName);
        this.updateTitle(this.record, this.recordsManagerName);
        params = new RecordsManagementAuditQueryParameters();
        params.setUser(this.recordsManagerName);
        this.getAuditTrail(params, 3, "admin");
        params = new RecordsManagementAuditQueryParameters();
        params.setDateFrom(snapShot);
        this.getAuditTrail(params, 13, "admin");
        params = new RecordsManagementAuditQueryParameters();
        params.setDateTo(snapShot);
        this.getAuditTrail(params, 14, "admin");
        params.setDateFrom(this.testStartTime);
        this.getAuditTrail(params, 15, "admin");
        this.updateTitle(this.record, "admin");
        this.updateTitle(this.record, "admin");
        this.updateTitle(this.record, "admin");
        params = new RecordsManagementAuditQueryParameters();
        params.setNodeRef(this.record);
        this.getAuditTrail(params, 5, "admin");
        params = new RecordsManagementAuditQueryParameters();
        params.setEvent("Update RM Object");
        this.getAuditTrail(params, 10, "admin");
    }

    public void testAdminMethods() throws InterruptedException {
        this.rmAuditService.stopAuditLog(this.filePlan);
        Thread.sleep(5000L);
        List<RecordsManagementAuditEntry> result1 = this.getAuditTrail("admin");
        RecordsManagementAuditServiceImplTest.assertNotNull(result1);
        this.updateTitle(this.filePlan, "admin");
        Thread.sleep(5000L);
        List<RecordsManagementAuditEntry> result2 = this.getAuditTrail("admin");
        RecordsManagementAuditServiceImplTest.assertNotNull(result2);
        RecordsManagementAuditServiceImplTest.assertEquals((String)"Audit results should not have changed after auditing was disabled", (int)result1.size(), (int)result2.size());
        this.rmAuditService.startAuditLog(this.filePlan);
        this.updateTitle(this.filePlan, "admin");
        Thread.sleep(5000L);
        List<RecordsManagementAuditEntry> result3 = this.getAuditTrail("admin");
        RecordsManagementAuditServiceImplTest.assertNotNull(result3);
        RecordsManagementAuditServiceImplTest.assertTrue((String)"Expected more results after enabling audit", (result3.size() > result1.size() ? 1 : 0) != 0);
        Thread.sleep(5000L);
        this.rmAuditService.stopAuditLog(this.filePlan);
        this.rmAuditService.clearAuditLog(this.filePlan);
        List<RecordsManagementAuditEntry> result4 = this.getAuditTrail("admin");
        RecordsManagementAuditServiceImplTest.assertNotNull(result4);
        RecordsManagementAuditServiceImplTest.assertEquals((String)"Audit entries should have been cleared", (int)0, (int)result4.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xtestAuditAuthentication() {
        this.rmAuditService.stopAuditLog(this.filePlan);
        this.rmAuditService.clearAuditLog(this.filePlan);
        this.rmAuditService.startAuditLog(this.filePlan);
        try {
            this.personService.deletePerson("baboon");
            this.authenticationService.deleteAuthentication("baboon");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            AuthenticationUtil.pushAuthentication();
            this.authenticationService.authenticate("baboon", "lskdfj".toCharArray());
            RecordsManagementAuditServiceImplTest.fail((String)"Expected authentication failure");
        }
        catch (AuthenticationException authenticationException) {
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        this.rmAuditService.stopAuditLog(this.filePlan);
        List<RecordsManagementAuditEntry> result1 = this.getAuditTrail("admin");
        RecordsManagementAuditServiceImplTest.assertFalse((String)"No audit results were generated for the failed login.", (boolean)result1.isEmpty());
        boolean found = false;
        for (RecordsManagementAuditEntry entry : result1) {
            String userName = entry.getUserName();
            if (!userName.equals("baboon")) continue;
            found = true;
            break;
        }
        RecordsManagementAuditServiceImplTest.assertTrue((String)"Expected to hit failed login attempt for user", (boolean)found);
        try {
            this.personService.deletePerson("cdickons");
            this.authenticationService.deleteAuthentication("cdickons");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.authenticationService.createAuthentication("cdickons", this.getName().toCharArray());
        HashMap<QName, String> personProperties = new HashMap<QName, String>();
        personProperties.put(ContentModel.PROP_USERNAME, "cdickons");
        personProperties.put(ContentModel.PROP_FIRSTNAME, "Charles");
        personProperties.put(ContentModel.PROP_LASTNAME, "Dickons");
        this.personService.createPerson(personProperties);
        this.rmAuditService.clearAuditLog(this.filePlan);
        this.rmAuditService.startAuditLog(this.filePlan);
        try {
            AuthenticationUtil.pushAuthentication();
            this.authenticationService.authenticate("cdickons", this.getName().toCharArray());
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        this.rmAuditService.stopAuditLog(this.filePlan);
        List<RecordsManagementAuditEntry> result2 = this.getAuditTrail("admin");
        found = false;
        for (RecordsManagementAuditEntry entry : result2) {
            String userName = entry.getUserName();
            String fullName = entry.getFullName();
            if (!userName.equals("cdickons") || !EqualsHelper.nullSafeEquals((Object)fullName, (Object)"Charles Dickons")) continue;
            found = true;
            break;
        }
        RecordsManagementAuditServiceImplTest.assertTrue((String)"Expected to hit successful login attempt for Charles Dickons (cdickons)", (boolean)found);
    }

    @Test
    public void testAuditForDeletedUser() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            static final String DELETE_USER_AUDIT_EVENT = "Delete Person";
            String userName;
            NodeRef user;
            List<RecordsManagementAuditEntry> entry;
            {
                this.userName = "auditDeleteUser";
            }

            @Override
            public void given() throws Exception {
                this.user = RecordsManagementAuditServiceImplTest.this.createPerson(this.userName);
                RecordsManagementAuditServiceImplTest.this.personService.deletePerson(this.userName);
            }

            @Override
            public void when() throws Exception {
                RecordsManagementAuditQueryParameters params = RecordsManagementAuditServiceImplTest.this.createAuditQueryParameters(DELETE_USER_AUDIT_EVENT);
                this.entry = RecordsManagementAuditServiceImplTest.this.getAuditTrail(params, 1, "admin");
            }

            @Override
            public void then() throws Exception {
                TestCase.assertEquals((String)"Delete user event is not audited.", (String)DELETE_USER_AUDIT_EVENT, (String)this.entry.get(0).getEvent());
                TestCase.assertEquals((String)this.user.getId(), (String)this.entry.get(0).getNodeName());
                TestCase.assertEquals((String)"Unexpected nr of properties audited for cm:person type when deleting a user.", (int)1, (int)this.entry.get(0).getBeforeProperties().size());
                TestCase.assertEquals((String)"Wrong value for username property is  audited", (Object)this.userName, this.entry.get(0).getBeforeProperties().get(ContentModel.PROP_USERNAME));
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    @Test
    public void testAuditForCreateUser() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            static final String CREATE_USER_AUDIT_EVENT = "Create Person";
            String userName;
            NodeRef user;
            List<RecordsManagementAuditEntry> entry;
            {
                this.userName = "auditCreateUser";
            }

            @Override
            public void given() throws Exception {
                this.user = RecordsManagementAuditServiceImplTest.this.createPerson(this.userName);
            }

            @Override
            public void when() throws Exception {
                RecordsManagementAuditQueryParameters params = RecordsManagementAuditServiceImplTest.this.createAuditQueryParameters(CREATE_USER_AUDIT_EVENT);
                this.entry = RecordsManagementAuditServiceImplTest.this.getAuditTrail(params, 1, "admin");
            }

            @Override
            public void then() throws Exception {
                TestCase.assertEquals((String)"Create user event is not audited.", (String)CREATE_USER_AUDIT_EVENT, (String)this.entry.get(0).getEvent());
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    public void testAuditForCreateHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            static final String CREATE_HOLD_AUDIT_EVENT = "Create Hold";
            String holdName;
            String holdReason;
            Map<QName, Serializable> auditEventProperties;
            {
                this.holdName = "Hold " + GUID.generate();
                this.holdReason = "Reason " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName, this.holdReason);
            }

            @Override
            public void when() {
                this.auditEventProperties = RecordsManagementAuditServiceImplTest.this.getAuditEntry(CREATE_HOLD_AUDIT_EVENT).getAfterProperties();
            }

            @Override
            public void then() {
                TestCase.assertEquals((String)"Create Hold event does not include hold name.", (Object)this.holdName, (Object)this.auditEventProperties.get(HOLD_NAME));
                TestCase.assertEquals((String)"Create Hold event does not include hold reason.", (Object)this.holdReason, (Object)this.auditEventProperties.get(RecordsManagementModel.PROP_HOLD_REASON));
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    public void testAuditForDeleteHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            static final String DELETE_HOLD_AUDIT_EVENT = "Delete Hold";
            String holdName;
            NodeRef hold;
            Map<QName, Serializable> auditEventProperties;
            {
                this.holdName = "Hold " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                this.hold = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName, "Reason " + GUID.generate());
            }

            @Override
            public void when() {
                RecordsManagementAuditServiceImplTest.this.utils.deleteHold(this.hold);
                this.auditEventProperties = RecordsManagementAuditServiceImplTest.this.getAuditEntry(DELETE_HOLD_AUDIT_EVENT).getBeforeProperties();
            }

            @Override
            public void then() {
                TestCase.assertEquals((String)"Delete Hold event does not include hold name.", (Object)this.holdName, (Object)this.auditEventProperties.get(HOLD_NAME));
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    public void testAuditForAddContentToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            static final String ADD_TO_HOLD_AUDIT_EVENT = "Add To Hold";
            String holdName;
            NodeRef hold;
            Map<QName, Serializable> auditEventProperties;
            {
                this.holdName = "Hold " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                this.hold = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName, "Reason " + GUID.generate());
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold, RecordsManagementAuditServiceImplTest.this.dmDocument);
            }

            @Override
            public void when() {
                this.auditEventProperties = RecordsManagementAuditServiceImplTest.this.getAuditEntry(ADD_TO_HOLD_AUDIT_EVENT).getAfterProperties();
            }

            @Override
            public void then() {
                TestCase.assertEquals((String)"Add To Hold event does not include hold name.", (Object)this.holdName, (Object)this.auditEventProperties.get(HOLD_NAME));
                String contentName = (String)((Object)RecordsManagementAuditServiceImplTest.this.nodeService.getProperty(RecordsManagementAuditServiceImplTest.this.dmDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)"Add To Hold event does not include content name.", (Object)contentName, (Object)this.auditEventProperties.get(ContentModel.PROP_NAME));
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    @Test
    public void testAuditForRemoveContentFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String holdName;
            NodeRef hold;
            {
                this.holdName = "Hold " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                this.hold = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName, "Reason " + GUID.generate());
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold, RecordsManagementAuditServiceImplTest.this.dmDocument);
            }

            @Override
            public void when() {
                RecordsManagementAuditServiceImplTest.this.utils.removeItemFromHold(this.hold, RecordsManagementAuditServiceImplTest.this.dmDocument);
            }

            @Override
            public void then() {
                Map auditEventProperties = RecordsManagementAuditServiceImplTest.this.getAuditEntry(RecordsManagementAuditServiceImplTest.REMOVE_FROM_HOLD_AUDIT_EVENT).getBeforeProperties();
                TestCase.assertEquals((String)"Remove From Hold event does not include hold name.", (Object)this.holdName, auditEventProperties.get(HOLD_NAME));
                String contentName = (String)((Object)RecordsManagementAuditServiceImplTest.this.nodeService.getProperty(RecordsManagementAuditServiceImplTest.this.dmDocument, ContentModel.PROP_NAME));
                TestCase.assertEquals((String)"Remove From Hold event does not include content name.", (Object)contentName, auditEventProperties.get(ContentModel.PROP_NAME));
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    @Test
    public void testAuditForRemoveContentFromMultipleHolds() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String holdName1;
            String holdName2;
            NodeRef hold1;
            NodeRef hold2;
            {
                this.holdName1 = "Hold " + GUID.generate();
                this.holdName2 = "Hold " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                this.hold1 = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName1, "Reason " + GUID.generate());
                this.hold2 = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName2, "Reason " + GUID.generate());
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold1, RecordsManagementAuditServiceImplTest.this.dmDocument);
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold2, RecordsManagementAuditServiceImplTest.this.dmDocument);
            }

            @Override
            public void when() {
                RecordsManagementAuditServiceImplTest.this.utils.removeItemsFromHolds(Arrays.asList(this.hold1, this.hold2), Arrays.asList(RecordsManagementAuditServiceImplTest.this.dmDocument));
            }

            @Override
            public void then() {
                List<RecordsManagementAuditEntry> auditEntries = RecordsManagementAuditServiceImplTest.this.getAuditEntries(RecordsManagementAuditServiceImplTest.REMOVE_FROM_HOLD_AUDIT_EVENT);
                TestCase.assertEquals((int)2, (int)auditEntries.size());
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    @Test
    public void testAuditForRemoveMultipleContentFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String holdName;
            NodeRef hold;
            {
                this.holdName = "Hold " + GUID.generate();
            }

            @Override
            public void given() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                this.hold = RecordsManagementAuditServiceImplTest.this.utils.createHold(RecordsManagementAuditServiceImplTest.this.filePlan, this.holdName, "Reason " + GUID.generate());
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold, RecordsManagementAuditServiceImplTest.this.dmDocument);
                RecordsManagementAuditServiceImplTest.this.utils.addItemToHold(this.hold, RecordsManagementAuditServiceImplTest.this.dmDocument1);
            }

            @Override
            public void when() {
                RecordsManagementAuditServiceImplTest.this.utils.removeItemsFromHolds(Arrays.asList(this.hold), Arrays.asList(RecordsManagementAuditServiceImplTest.this.dmDocument, RecordsManagementAuditServiceImplTest.this.dmDocument1));
            }

            @Override
            public void then() {
                List<RecordsManagementAuditEntry> auditEntries = RecordsManagementAuditServiceImplTest.this.getAuditEntries(RecordsManagementAuditServiceImplTest.REMOVE_FROM_HOLD_AUDIT_EVENT);
                TestCase.assertEquals((int)2, (int)auditEntries.size());
            }

            @Override
            public void after() {
                RecordsManagementAuditServiceImplTest.this.rmAuditService.stopAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
                RecordsManagementAuditServiceImplTest.this.rmAuditService.clearAuditLog(RecordsManagementAuditServiceImplTest.this.filePlan);
            }
        });
    }

    private List<RecordsManagementAuditEntry> getAuditTrail(String asUser) {
        return this.getAuditTrail(-1, asUser);
    }

    private List<RecordsManagementAuditEntry> getAuditTrail(int expectedCount, String asUser) {
        return this.getAuditTrail(new RecordsManagementAuditQueryParameters(), expectedCount, asUser);
    }

    private List<RecordsManagementAuditEntry> getAuditTrail(final RecordsManagementAuditQueryParameters params, final int expectedCount, String asUser) {
        return (List)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<List<RecordsManagementAuditEntry>>(){

            public List<RecordsManagementAuditEntry> run() throws Exception {
                return RecordsManagementAuditServiceImplTest.this.rmAuditService.getAuditTrail(params);
            }

            public void test(List<RecordsManagementAuditEntry> result) throws Exception {
                TestCase.assertNotNull(result);
                if (expectedCount != -1) {
                    TestCase.assertEquals((int)expectedCount, (int)result.size());
                }
            }
        }, asUser);
    }

    private String updateTitle(final NodeRef nodeRef, String asUser) {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() throws Exception {
                String updatedProperty = "Updated - " + System.currentTimeMillis();
                RecordsManagementAuditServiceImplTest.this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)updatedProperty));
                return updatedProperty;
            }
        }, asUser);
    }

    private RecordsManagementAuditEntry getAuditEntry(String auditEvent) {
        RecordsManagementAuditQueryParameters params = this.createAuditQueryParameters(auditEvent);
        List<RecordsManagementAuditEntry> auditEntries = this.getAuditEntryAssertOnlyOne(params);
        RecordsManagementAuditEntry auditEntry = auditEntries.get(0);
        RecordsManagementAuditServiceImplTest.assertEquals((String)(auditEvent + " event is not audited."), (String)auditEvent, (String)auditEntry.getEvent());
        return auditEntry;
    }

    private List<RecordsManagementAuditEntry> getAuditEntryAssertOnlyOne(RecordsManagementAuditQueryParameters params) {
        List<RecordsManagementAuditEntry> auditEntries = this.getAuditTrail(params, 1, "admin");
        return auditEntries;
    }

    private List<RecordsManagementAuditEntry> getAuditEntries(String auditEvent) {
        RecordsManagementAuditQueryParameters params = this.createAuditQueryParameters(auditEvent);
        List<RecordsManagementAuditEntry> auditEntries = this.getAllAuditEntries(params);
        return auditEntries;
    }

    private List<RecordsManagementAuditEntry> getAllAuditEntries(RecordsManagementAuditQueryParameters params) {
        List<RecordsManagementAuditEntry> auditEntries = this.getAuditTrail(params, -1, "admin");
        return auditEntries;
    }

    private RecordsManagementAuditQueryParameters createAuditQueryParameters(String auditEvent) {
        RecordsManagementAuditQueryParameters params = new RecordsManagementAuditQueryParameters();
        params.setEvent(auditEvent);
        return params;
    }
}

