/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.evaluator;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionConditionEvaluatorAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.action.evaluator.DispositionActionRelativePositions;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class HasDispositionActionEvaluator
extends RecordsManagementActionConditionEvaluatorAbstractBase {
    public static final String NAME = "hasDispositionAction";
    public static final String PARAM_DISPOSITION_ACTION_RELATIVE_POSITION = "position";
    public static final String PARAM_DISPOSITION_ACTION = "action";
    private DispositionService dispositionService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    protected boolean evaluateImpl(ActionCondition actionCondition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        String position = ((QName)actionCondition.getParameterValue(PARAM_DISPOSITION_ACTION_RELATIVE_POSITION)).getLocalName();
        String action = ((QName)actionCondition.getParameterValue(PARAM_DISPOSITION_ACTION)).getLocalName();
        if (this.dispositionService.isDisposableItem(actionedUponNodeRef)) {
            String actionName;
            DispositionAction lastCompletedDispositionAction;
            if (position.equals(DispositionActionRelativePositions.ANY.toString())) {
                DispositionSchedule dispositionSchedule = this.dispositionService.getDispositionSchedule(actionedUponNodeRef);
                if (dispositionSchedule != null) {
                    for (DispositionActionDefinition dispositionActionDefinition : dispositionSchedule.getDispositionActionDefinitions()) {
                        if (!dispositionActionDefinition.getName().equals(action)) continue;
                        result = true;
                        break;
                    }
                }
            } else if (position.equals(DispositionActionRelativePositions.NEXT.toString())) {
                String actionName2;
                DispositionAction nextDispositionAction = this.dispositionService.getNextDispositionAction(actionedUponNodeRef);
                if (nextDispositionAction != null && (actionName2 = nextDispositionAction.getName()).equals(action)) {
                    result = true;
                }
            } else if (position.equals(DispositionActionRelativePositions.PREVIOUS.toString()) && (lastCompletedDispositionAction = this.dispositionService.getLastCompletedDispostionAction(actionedUponNodeRef)) != null && (actionName = lastCompletedDispositionAction.getName()).equals(action)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_DISPOSITION_ACTION_RELATIVE_POSITION, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_DISPOSITION_ACTION_RELATIVE_POSITION), false, "rm-ac-disposition-action-relative-positions"));
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_DISPOSITION_ACTION, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_DISPOSITION_ACTION), false, "rm-ac-disposition-actions"));
    }
}

