/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.parameter.ParameterProcessor;
import org.alfresco.repo.action.parameter.ParameterSubstitutionSuggester;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.repository.NodeRef;

public class ParameterProcessorComponent
implements ParameterSubstitutionSuggester {
    private static final String REG_EX_OLD = "\\$\\{([^\\$\\{]+)\\}";
    private static final String REG_EX = "\\{([^\\{]+)\\}";
    private Map<String, ParameterProcessor> processors = new HashMap<String, ParameterProcessor>(5);
    private List<ParameterSubstitutionSuggester> subtitutionSuggesterProcessors = new ArrayList<ParameterSubstitutionSuggester>(5);

    public void register(ParameterProcessor processor) {
        this.processors.put(processor.getName(), processor);
        if (processor instanceof ParameterSubstitutionSuggester) {
            this.subtitutionSuggesterProcessors.add((ParameterSubstitutionSuggester)((Object)processor));
        }
    }

    public void process(ParameterizedItem ruleItem, ParameterizedItemDefinition ruleItemDefinition, NodeRef actionedUponNodeRef) {
        for (Map.Entry entry : ruleItem.getParameterValues().entrySet()) {
            String parameterName = (String)entry.getKey();
            Object parameterValue = entry.getValue();
            if (!(parameterValue instanceof String)) continue;
            ruleItem.setParameterValue(parameterName, (Serializable)((Object)this.process((String)parameterValue, actionedUponNodeRef)));
        }
    }

    public String process(String value, NodeRef nodeRef) {
        return this.process(this.process(value, nodeRef, REG_EX_OLD), nodeRef, REG_EX);
    }

    public String process(String value, NodeRef nodeRef, String regExp) {
        Pattern patt = Pattern.compile(regExp);
        Matcher m = patt.matcher(value);
        StringBuffer sb = new StringBuffer(value.length());
        while (m.find()) {
            String text = m.group(1);
            ParameterProcessor processor = this.lookupProcessor(text);
            if (processor == null) {
                throw new AlfrescoRuntimeException("A parameter processor has not been found for the substitution string " + text);
            }
            text = processor.process(text, nodeRef);
            m.appendReplacement(sb, Matcher.quoteReplacement(text));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public List<String> getSubstitutionSuggestions(String substitutionFragment) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (ParameterSubstitutionSuggester suggestor : this.subtitutionSuggesterProcessors) {
            suggestions.addAll(suggestor.getSubstitutionSuggestions(substitutionFragment.toLowerCase()));
        }
        return suggestions;
    }

    private ParameterProcessor lookupProcessor(String value) {
        String[] values;
        ParameterProcessor result = null;
        if (value != null && !value.isEmpty() && (values = value.split("\\.", 2)).length != 0) {
            result = this.processors.get(values[0]);
        }
        return result;
    }
}

