/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionServiceImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DispositionServiceImplUnitTest {
    NodeRef CONTENT_NODE_REF = new NodeRef("content://node/");
    private DispositionServiceImpl dispositionService = new DispositionServiceImpl();
    private NodeService mockNodeService = (NodeService)Mockito.mock(NodeService.class);

    @Before
    public void setUp() {
        this.dispositionService.setNodeService(this.mockNodeService);
    }

    @Test
    public void testCalculateAsOfDate() {
        DispositionActionDefinition mockDispositionActionDefinition = (DispositionActionDefinition)Mockito.mock(DispositionActionDefinition.class);
        Period mockPeriod = (Period)Mockito.mock(Period.class);
        Mockito.when((Object)mockDispositionActionDefinition.getPeriod()).thenReturn((Object)mockPeriod);
        Mockito.when((Object)mockDispositionActionDefinition.getPeriodProperty()).thenReturn((Object)ContentModel.PROP_CREATED);
        Date createdDate = new Date(1234567890L);
        Mockito.when((Object)this.mockNodeService.getProperty(this.CONTENT_NODE_REF, ContentModel.PROP_CREATED)).thenReturn((Object)createdDate);
        Date nextDate = new Date(1240000000L);
        Mockito.when((Object)mockPeriod.getNextDate(createdDate)).thenReturn((Object)nextDate);
        Date asOfDate = this.dispositionService.calculateAsOfDate(this.CONTENT_NODE_REF, mockDispositionActionDefinition);
        Assert.assertEquals((String)"Unexpected calculation for 'as of' date", (Object)nextDate, (Object)asOfDate);
    }

    @Test
    public void testCalculateAsOfDate_nullPeriod() {
        DispositionActionDefinition mockDispositionActionDefinition = (DispositionActionDefinition)Mockito.mock(DispositionActionDefinition.class);
        Mockito.when((Object)mockDispositionActionDefinition.getPeriod()).thenReturn(null);
        Date asOfDate = this.dispositionService.calculateAsOfDate(this.CONTENT_NODE_REF, mockDispositionActionDefinition);
        Assert.assertNull((String)"It should not be possible to determine the 'as of' date.", (Object)asOfDate);
    }
}

