/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.policy;

import org.alfresco.module.org_alfresco_module_rm.capability.policy.AbstractBasePolicy;
import org.alfresco.module.org_alfresco_module_rm.capability.policy.ConfigAttributeDefinition;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.aopalliance.intercept.MethodInvocation;

public class AssocPolicy
extends AbstractBasePolicy {
    @Override
    public int evaluate(MethodInvocation invocation, Class[] params, ConfigAttributeDefinition cad) {
        NodeRef source = null;
        if (cad.getParameters().get(0) > -1) {
            source = this.getTestNode(invocation, params, cad.getParameters().get(0), cad.isParent());
        }
        NodeRef target = null;
        if (cad.getParameters().get(1) > -1) {
            target = this.getTestNode(invocation, params, cad.getParameters().get(1), cad.isParent());
        }
        if (source != null && target != null) {
            if (this.nodeService.hasAspect(source, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
                return this.getCapabilityService().getCapability("ViewRecords").evaluate(source);
            }
            boolean isFilePlanComponent = this.nodeService.hasAspect(target, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
            boolean hasViewRecordCapability = this.getCapabilityService().hasCapability(target, "ViewRecords");
            if (isFilePlanComponent && hasViewRecordCapability && this.permissionService.hasPermission(source, "WriteProperties").equals((Object)AccessStatus.ALLOWED)) {
                return 1;
            }
            return -1;
        }
        return -1;
    }
}

