/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v22;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class RMv22GhostOnDestroyDispositionActionPatch
extends AbstractModulePatch {
    private DispositionService dispositionService;
    private FilePlanService filePlanService;
    private NodeService nodeService;
    private boolean ghostingEnabled;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setGhostingEnabled(boolean ghostingEnabled) {
        this.ghostingEnabled = ghostingEnabled;
    }

    @Override
    public void applyInternal() {
        Set<NodeRef> filePlans = this.filePlanService.getFilePlans();
        for (NodeRef filePlan : filePlans) {
            this.processFilePlan(filePlan);
        }
    }

    private void processFilePlan(NodeRef filePlan) {
        HashSet<DispositionSchedule> dispositionSchedules = new HashSet<DispositionSchedule>();
        this.getDispositionSchedules(filePlan, dispositionSchedules);
        for (DispositionSchedule dispositionSchedule : dispositionSchedules) {
            this.processDispositionSchedule(dispositionSchedule);
        }
    }

    private void getDispositionSchedules(NodeRef nodeRef, Set<DispositionSchedule> dispositionSchedules) {
        if (this.filePlanService.isRecordCategory(nodeRef)) {
            DispositionSchedule dispositionSchedule = this.dispositionService.getDispositionSchedule(nodeRef);
            if (dispositionSchedule != null) {
                dispositionSchedules.add(dispositionSchedule);
            }
            List children = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef childAssoc : children) {
                this.getDispositionSchedules(childAssoc.getChildRef(), dispositionSchedules);
            }
        }
    }

    private void processDispositionSchedule(DispositionSchedule dispositionSchedule) {
        List<DispositionActionDefinition> actionDefinitions = dispositionSchedule.getDispositionActionDefinitions();
        for (DispositionActionDefinition actionDefinition : actionDefinitions) {
            String ghostOnDestroyValue;
            String actionName = (String)((Object)this.nodeService.getProperty(actionDefinition.getNodeRef(), RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME));
            if (!"destroy".equals(actionName) || (ghostOnDestroyValue = (String)((Object)this.nodeService.getProperty(actionDefinition.getNodeRef(), RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY))) != null) continue;
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
            props.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY, (Serializable)((Object)(this.ghostingEnabled ? "ghost" : "destroy")));
            this.dispositionService.updateDispositionActionDefinition(actionDefinition, props);
        }
    }
}

