/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.files;

import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.Record;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="files", title="Files")
public class FilesEntityResource
implements InitializingBean {
    private ApiNodesModelFactory nodesModelFactory;
    private FilePlanComponentsApiUtils apiUtils;
    private AuthenticationUtil authenticationUtil;
    private FilePlanService filePlanService;
    private FileFolderService fileFolderService;
    private RecordService recordService;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Operation(value="declare")
    @WebApiDescription(title="Declare as record", description="Declare a file as record.")
    public Record declareAsRecord(String fileId, Void body, Parameters parameters, WithResponse withResponse) {
        final NodeRef filePlan = this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() {
                return FilesEntityResource.this.filePlanService.getFilePlanBySiteId("rm");
            }
        });
        final boolean hideRecord = Boolean.valueOf(parameters.getParameter("hideRecord"));
        final NodeRef targetRecordFolder = this.extractAndValidateTargetRecordFolder(parameters);
        final NodeRef file = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, fileId);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                FilesEntityResource.this.recordService.createRecord(filePlan, file, targetRecordFolder, !hideRecord);
                if (targetRecordFolder != null) {
                    FilesEntityResource.this.recordService.file(file);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        FileInfo info = this.fileFolderService.getFileInfo(file);
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }

    private NodeRef extractAndValidateTargetRecordFolder(Parameters parameters) {
        NodeRef targetParent = null;
        String targetParentId = parameters.getParameter("parentId");
        if (targetParentId != null) {
            targetParent = this.apiUtils.lookupAndValidateNodeType(targetParentId, RecordsManagementModel.TYPE_RECORD_FOLDER);
        }
        return targetParent;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"authenticationUtil", (Object)this.authenticationUtil);
        ParameterCheck.mandatory((String)"filePlanService", (Object)this.filePlanService);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"recordService", (Object)this.recordService);
    }
}

