/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.transfercontainers;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.TransferContainer;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="transfer-containers", title="Transfer Containers")
public class TransferContainerEntityResource
implements EntityResourceAction.ReadById<TransferContainer>,
EntityResourceAction.Update<TransferContainer>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get transfer container information", description="Gets information for a transfer container with id 'transferContainerId'")
    @WebApiParam(name="transferContainerId", title="The transfer container id")
    public TransferContainer readById(String transferContainerId, Parameters parameters) throws EntityNotFoundException {
        RMParameterCheck.checkNotBlank("transferContainerId", transferContainerId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(transferContainerId, RecordsManagementModel.TYPE_TRANSFER_CONTAINER);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createTransferContainer(info, parameters, null, false);
    }

    @WebApiDescription(title="Update transfer container", description="Updates a transfer container with id 'transferContainerId'")
    public TransferContainer update(String transferContainerId, final TransferContainer transferContainerInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("transferContainerId", transferContainerId);
        ParameterCheck.mandatory((String)"transferContainerInfo", (Object)transferContainerInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(transferContainerId, RecordsManagementModel.TYPE_TRANSFER_CONTAINER);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                TransferContainerEntityResource.this.apiUtils.updateTransferContainer(nodeRef, transferContainerInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return TransferContainerEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        return this.nodesModelFactory.createTransferContainer(info, parameters, null, false);
    }
}

