/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bootstrap;

import org.alfresco.module.org_alfresco_module_rm.bootstrap.ModuleCompatibilityComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public class ModuleCompatibilityComponentUnitTest {
    @Mock
    private DescriptorService mockedDescriptorService;
    @Mock
    private ModuleService mockedModuleService;
    @Mock
    private ContextRefreshedEvent mockedContextRefreshedEvent;
    @Mock
    private ConfigurableApplicationContext mockedApplicationContext;
    @Mock
    private ModuleDetails mockedModuleDetails;
    @Mock
    private LicenseDescriptor mockedDescriptor;
    @InjectMocks
    private ModuleCompatibilityComponent moduleCompatibilityComponent;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockedContextRefreshedEvent.getApplicationContext()).thenReturn((Object)this.mockedApplicationContext);
        Mockito.when((Object)this.mockedDescriptorService.getLicenseDescriptor()).thenReturn((Object)this.mockedDescriptor);
    }

    @Test
    public void communityOnCommunity() {
        Mockito.when((Object)this.mockedDescriptor.getLicenseMode()).thenReturn((Object)RepoUsage.LicenseMode.UNKNOWN);
        Mockito.when((Object)this.mockedModuleService.getModule(ArgumentMatchers.anyString())).thenReturn(null);
        this.moduleCompatibilityComponent.onApplicationEvent(this.mockedContextRefreshedEvent);
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockedApplicationContext, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void enterpriseOnCommunity() {
        Mockito.when((Object)this.mockedDescriptor.getLicenseMode()).thenReturn((Object)RepoUsage.LicenseMode.UNKNOWN);
        Mockito.when((Object)this.mockedModuleService.getModule(ArgumentMatchers.anyString())).thenReturn((Object)this.mockedModuleDetails);
        this.moduleCompatibilityComponent.onApplicationEvent(this.mockedContextRefreshedEvent);
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockedApplicationContext)).close();
    }

    @Test
    public void communityOnEnterprise() {
        Mockito.when((Object)this.mockedDescriptor.getLicenseMode()).thenReturn((Object)RepoUsage.LicenseMode.ENTERPRISE);
        Mockito.when((Object)this.mockedModuleService.getModule(ArgumentMatchers.anyString())).thenReturn(null);
        this.moduleCompatibilityComponent.onApplicationEvent(this.mockedContextRefreshedEvent);
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockedApplicationContext)).close();
    }

    @Test
    public void enterpriseOnEnterprise() {
        Mockito.when((Object)this.mockedDescriptor.getLicenseMode()).thenReturn((Object)RepoUsage.LicenseMode.ENTERPRISE);
        Mockito.when((Object)this.mockedModuleService.getModule(ArgumentMatchers.anyString())).thenReturn((Object)this.mockedModuleDetails);
        this.moduleCompatibilityComponent.onApplicationEvent(this.mockedContextRefreshedEvent);
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockedApplicationContext, (VerificationMode)Mockito.never())).close();
    }
}

