/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.transfer;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;

public class NoPermissionsOnTransferFolderTest
extends BaseRMTestCase {
    private String testUser1 = null;
    private String testUser2 = null;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.testUser1 = GUID.generate();
        this.createPerson(this.testUser1);
        this.testUser2 = GUID.generate();
        this.createPerson(this.testUser2);
        this.siteService.setMembership(this.siteId, this.testUser1, "SiteConsumer");
        this.siteService.setMembership(this.siteId, this.testUser2, "SiteConsumer");
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.testUser1);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.testUser2);
    }

    public void testNoPermissionsOnTransferFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.testUser1){
            private NodeRef recordsFolder;
            private NodeRef transferFolder;
            {
                this.recordsFolder = null;
                this.transferFolder = null;
            }

            @Override
            public void given() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        NodeRef category = NoPermissionsOnTransferFolderTest.this.filePlanService.createRecordCategory(NoPermissionsOnTransferFolderTest.this.filePlan, GUID.generate());
                        NoPermissionsOnTransferFolderTest.this.filePlanPermissionService.setPermission(category, NoPermissionsOnTransferFolderTest.this.testUser1, "Filing");
                        NoPermissionsOnTransferFolderTest.this.filePlanPermissionService.setPermission(category, NoPermissionsOnTransferFolderTest.this.testUser2, "Filing");
                        NoPermissionsOnTransferFolderTest.this.utils.createDispositionSchedule(category, "disposition instructions", "disposition authority", false, true, true);
                        recordsFolder = NoPermissionsOnTransferFolderTest.this.recordFolderService.createRecordFolder(category, GUID.generate());
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("eventName", "case_closed");
                        NoPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "completeEvent", params);
                        NoPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(recordsFolder, "cutoff");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
                this.transferFolder = (NodeRef)NoPermissionsOnTransferFolderTest.this.rmActionService.executeRecordsManagementAction(this.recordsFolder, "transfer").getValue();
            }

            @Override
            public void when() {
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.transferFolder);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)NoPermissionsOnTransferFolderTest.this.permissionService.hasPermission(NoPermissionsOnTransferFolderTest.this.transfersContainer, "ReadRecords"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)NoPermissionsOnTransferFolderTest.this.permissionService.hasPermission(this.transferFolder, "Filing"));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        TestCase.assertNotNull((Object)transferFolder);
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)NoPermissionsOnTransferFolderTest.this.permissionService.hasPermission(NoPermissionsOnTransferFolderTest.this.transfersContainer, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)NoPermissionsOnTransferFolderTest.this.permissionService.hasPermission(transferFolder, "ReadRecords"));
                        return null;
                    }
                }, (String)NoPermissionsOnTransferFolderTest.this.testUser2);
            }
        });
    }
}

