/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition.property;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.BooleanUtils;

@BehaviourBean
public class DispositionProperty
extends BaseBehaviourBean
implements NodeServicePolicies.OnUpdatePropertiesPolicy {
    private QName propertyName;
    private NamespaceService namespaceService;
    private DispositionService dispositionService;
    private boolean appliesToFolderLevel = true;
    private boolean appliesToRecordLevel = true;
    private Set<String> excludedDispositionActions;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setName(String propertyName) {
        this.propertyName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
    }

    public QName getQName() {
        return this.propertyName;
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.dictionaryService.getProperty(this.propertyName);
    }

    public void setExcludedDispositionActions(Set<String> excludedDispositionActions) {
        this.excludedDispositionActions = excludedDispositionActions;
    }

    public void setAppliesToFolderLevel(boolean appliesToFolderLevel) {
        this.appliesToFolderLevel = appliesToFolderLevel;
    }

    public void setAppliesToRecordLevel(boolean appliesToRecordLevel) {
        this.appliesToRecordLevel = appliesToRecordLevel;
    }

    public void init() {
        this.dispositionService.registerDispositionProperty(this);
    }

    public boolean applies(boolean isRecordLevel, String dispositionAction) {
        boolean result = false;
        if (isRecordLevel && this.appliesToRecordLevel || !isRecordLevel && this.appliesToFolderLevel) {
            if (this.excludedDispositionActions != null && this.excludedDispositionActions.size() != 0) {
                if (!this.excludedDispositionActions.contains(dispositionAction)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:dispositionLifecycle", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef) && this.isPropertyUpdated(before, after)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    Date updatedDateValue = (Date)after.get(DispositionProperty.this.propertyName);
                    if (updatedDateValue != null) {
                        DispositionActionDefinition daDefinition;
                        DispositionAction dispositionAction = DispositionProperty.this.dispositionService.getNextDispositionAction(nodeRef);
                        if (dispositionAction != null && (daDefinition = dispositionAction.getDispositionActionDefinition()) != null && DispositionProperty.this.propertyName.equals((Object)daDefinition.getPeriodProperty())) {
                            Period period = daDefinition.getPeriod();
                            Date updatedAsOf = period.getNextDate(updatedDateValue);
                            NodeRef daNodeRef = dispositionAction.getNodeRef();
                            if (BooleanUtils.isNotTrue((Boolean)((Boolean)DispositionProperty.this.nodeService.getProperty(daNodeRef, RecordsManagementModel.PROP_MANUALLY_SET_AS_OF)))) {
                                DispositionProperty.this.nodeService.setProperty(daNodeRef, RecordsManagementModel.PROP_DISPOSITION_AS_OF, (Serializable)updatedAsOf);
                            }
                        }
                    } else if (before.get(DispositionProperty.this.propertyName) != null) {
                        throw new AlfrescoRuntimeException("Error updating property " + DispositionProperty.this.propertyName.toPrefixString((NamespacePrefixResolver)DispositionProperty.this.namespaceService) + " to null, because property is being used to determine a disposition date.");
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private boolean isPropertyUpdated(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Serializable afterValue;
        Serializable beforeValue = before.get(this.propertyName);
        return !Objects.equals(beforeValue, afterValue = after.get(this.propertyName));
    }
}

