/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UserRightsReportGet
extends DeclarativeWebScript {
    protected AuthorityService authorityService;
    protected PersonService personService;
    protected NodeService nodeService;
    protected FilePlanRoleService filePlanRoleService;
    protected FilePlanService filePlanService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef filePlanNode = this.filePlanService.getFilePlanBySiteId("rm");
        if (filePlanNode == null) {
            status.setCode(400, "The default RM site could not be found.");
            return null;
        }
        HashMap<String, UserModel> usersMap = new HashMap<String, UserModel>(8);
        HashMap<String, RoleModel> rolesMap = new HashMap<String, RoleModel>(8);
        HashMap<String, GroupModel> groupsMap = new HashMap<String, GroupModel>(8);
        Set<Role> roles = this.filePlanRoleService.getRoles(filePlanNode);
        for (Role role : roles) {
            String roleName = role.getName();
            RoleModel roleModel = (RoleModel)rolesMap.get(roleName);
            if (roleModel == null) {
                roleModel = new RoleModel(role);
                rolesMap.put(roleName, roleModel);
            }
            String group = role.getRoleGroupName();
            Set users = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, false);
            roleModel.setUsers(users);
            for (String userName : users) {
                UserModel userModel = (UserModel)usersMap.get(userName);
                if (userModel == null) {
                    NodeRef userRef = this.personService.getPerson(userName);
                    userModel = new UserModel(userName, (String)((Object)this.nodeService.getProperty(userRef, ContentModel.PROP_FIRSTNAME)), (String)((Object)this.nodeService.getProperty(userRef, ContentModel.PROP_LASTNAME)));
                    usersMap.put(userName, userModel);
                }
                userModel.addRole(roleName);
            }
            Set groups = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, group, false);
            roleModel.setGroups(groups);
            for (String groupName : groups) {
                GroupModel groupModel = (GroupModel)groupsMap.get(groupName);
                if (groupModel == null) {
                    groupModel = new GroupModel(groupName, this.authorityService.getAuthorityDisplayName(groupName));
                    groupsMap.put(groupName, groupModel);
                }
                Set groupUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, groupName, true);
                for (String userName : groupUsers) {
                    UserModel userModel = (UserModel)usersMap.get(userName);
                    if (userModel == null) {
                        NodeRef userRef = this.personService.getPerson(userName);
                        userModel = new UserModel(userName, (String)((Object)this.nodeService.getProperty(userRef, ContentModel.PROP_FIRSTNAME)), (String)((Object)this.nodeService.getProperty(userRef, ContentModel.PROP_LASTNAME)));
                        usersMap.put(userName, userModel);
                    }
                    userModel.addGroup(groupName);
                    userModel.addRole(roleName);
                    groupModel.addUser(userName);
                }
            }
        }
        HashMap<String, HashMap<String, Object>> reportModel = new HashMap<String, HashMap<String, Object>>(4);
        reportModel.put("users", usersMap);
        reportModel.put("roles", rolesMap);
        reportModel.put("groups", groupsMap);
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("report", reportModel);
        return model;
    }

    public class RoleModel
    extends Role {
        private Set<String> users;
        private Set<String> groups;

        public RoleModel(Role role) {
            super(role.getName(), role.getDisplayLabel(), role.getCapabilities(), role.getRoleGroupName());
            this.users = new HashSet<String>(8);
            this.groups = new HashSet<String>(8);
        }

        public void addUser(String username) {
            this.users.add(username);
        }

        public void addGroup(String groupName) {
            this.groups.add(groupName);
        }

        public void setUsers(Set<String> users) {
            this.users = users;
        }

        public void setGroups(Set<String> groups) {
            this.groups = groups;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public Set<String> getGroups() {
            return this.groups;
        }
    }

    public class UserModel {
        private String userName;
        private String firstName;
        private String lastName;
        private Set<String> roles;
        private Set<String> groups;

        public UserModel(String userName, String firstName, String lastName) {
            this.userName = userName;
            this.firstName = firstName;
            this.lastName = lastName;
            this.roles = new HashSet<String>(2);
            this.groups = new HashSet<String>(2);
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public void addRole(String roleName) {
            this.roles.add(roleName);
        }

        public void addGroup(String groupName) {
            this.groups.add(groupName);
        }
    }

    public class GroupModel {
        private String name;
        private String label;
        private Set<String> users;

        public GroupModel(String name, String label) {
            this.name = name;
            this.label = label;
            this.users = new HashSet<String>(4);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayLabel() {
            return this.label;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public void addUser(String userName) {
            this.users.add(userName);
        }
    }
}

