/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.notification;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.notification.NotificationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordsManagementNotificationHelper
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(RecordsManagementNotificationHelper.class);
    private static final String MSG_SUBJECT_RECORDS_DUE_FOR_REVIEW = "notification.dueforreview.subject";
    private static final String MSG_SUBJECT_RECORD_SUPERCEDED = "notification.superseded.subject";
    private static final String MSG_SUBJECT_RECORD_REJECTED = "notification.rejected.subject";
    private static final String DEFAULT_SITE = "rm";
    private NotificationService notificationService;
    private FilePlanRoleService filePlanRoleService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private SiteService siteService;
    private AuthorityService authorityService;
    private TenantAdminService tenantAdminService;
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private String notificationRole;
    private NodeRef supersededTemplate = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "record_superseded_template");
    private NodeRef dueForReviewTemplate;
    private NodeRef rejectedTemplate = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "record_rejected_template");

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setNotificationRole(String notificationRole) {
        this.notificationRole = notificationRole;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public NodeRef getSupersededTemplate() {
        return this.supersededTemplate;
    }

    public NodeRef getRejectedTemplate() {
        return this.rejectedTemplate;
    }

    public NodeRef getDueForReviewTemplate() {
        List nodeRefs;
        if (this.dueForReviewTemplate == null && (nodeRefs = this.searchService.selectNodes(this.getRootNode(), "app:company_home/app:dictionary/cm:records_management/cm:records_management_email_templates/cm:notify-records-due-for-review-email.ftl", null, (NamespacePrefixResolver)this.namespaceService, false)).size() == 1) {
            this.dueForReviewTemplate = (NodeRef)nodeRefs.get(0);
        }
        return this.dueForReviewTemplate;
    }

    private NodeRef getRootNode() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        return (NodeRef)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() {
                return RecordsManagementNotificationHelper.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            }
        }, (String)tenantDomain);
    }

    public void recordsDueForReviewEmailNotification(List<NodeRef> records) {
        ParameterCheck.mandatory((String)"records", records);
        if (!records.isEmpty() && this.nodeService.hasAspect(records.get(0), RecordsManagementModel.ASPECT_RECORD)) {
            NodeRef root = this.getRMRoot(records.get(0));
            String groupName = this.getGroupName(root);
            if (this.doesGroupContainUsers(groupName)) {
                NotificationContext notificationContext = new NotificationContext();
                notificationContext.setSubject(I18NUtil.getMessage((String)MSG_SUBJECT_RECORDS_DUE_FOR_REVIEW));
                notificationContext.setAsyncNotification(false);
                notificationContext.setIgnoreNotificationFailure(true);
                notificationContext.setBodyTemplate(this.getDueForReviewTemplate().toString());
                HashMap<String, Object> args = new HashMap<String, Object>(1, 1.0f);
                args.put("records", (Serializable)((Object)records));
                args.put("site", this.getSiteName(root));
                notificationContext.setTemplateArgs(args);
                notificationContext.addTo(groupName);
                this.notificationService.sendNotification("email", notificationContext);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Unable to send record due for review email notification, because notification group was empty.");
                }
                throw new AlfrescoRuntimeException("Unable to send record due for review email notification, because notification group was empty.");
            }
        }
    }

    public void recordSupersededEmailNotification(NodeRef record) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        NodeRef root = this.getRMRoot(record);
        String groupName = this.getGroupName(root);
        if (this.doesGroupContainUsers(groupName)) {
            NotificationContext notificationContext = new NotificationContext();
            notificationContext.setSubject(I18NUtil.getMessage((String)MSG_SUBJECT_RECORD_SUPERCEDED));
            notificationContext.setAsyncNotification(false);
            notificationContext.setIgnoreNotificationFailure(true);
            notificationContext.setBodyTemplate(this.supersededTemplate.toString());
            HashMap<String, Object> args = new HashMap<String, Object>(1, 1.0f);
            args.put("record", record);
            args.put("site", this.getSiteName(root));
            notificationContext.setTemplateArgs(args);
            notificationContext.addTo(groupName);
            this.notificationService.sendNotification("email", notificationContext);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Unable to send record superseded email notification, because notification group was empty.");
        }
    }

    public void recordRejectedEmailNotification(NodeRef record, String recordId, String recordCreator) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        if (this.canSendRejectEmail(record, recordCreator)) {
            String site = this.siteService.getSite(record).getShortName();
            String rejectReason = (String)((Object)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_REASON));
            String rejectedPerson = (String)((Object)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_USER_ID));
            Date rejectDate = (Date)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_DATE);
            String recordName = (String)((Object)this.nodeService.getProperty(record, ContentModel.PROP_NAME));
            HashMap<String, Object> args = new HashMap<String, Object>(8);
            args.put("record", record);
            args.put("site", site);
            args.put("recordCreator", recordCreator);
            args.put("rejectReason", rejectReason);
            args.put("rejectedPerson", rejectedPerson);
            args.put("rejectDate", rejectDate);
            args.put("recordId", recordId);
            args.put("recordName", recordName);
            NotificationContext notificationContext = new NotificationContext();
            notificationContext.setAsyncNotification(true);
            notificationContext.setIgnoreNotificationFailure(true);
            notificationContext.addTo(recordCreator);
            notificationContext.setSubject(I18NUtil.getMessage((String)MSG_SUBJECT_RECORD_REJECTED));
            notificationContext.setBodyTemplate(this.getRejectedTemplate().toString());
            notificationContext.setTemplateArgs(args);
            this.notificationService.sendNotification("email", notificationContext);
        }
    }

    private boolean canSendRejectEmail(NodeRef record, String recordCreator) {
        boolean result = true;
        String msg1 = "Unable to send record rejected email notification, because ";
        String msg2 = " could not be found!";
        if (this.siteService.getSite(record) == null) {
            result = false;
            logger.warn((Object)(msg1 + "the site which should contain the node '" + record.toString() + "'" + msg2));
        }
        if (StringUtils.isBlank((CharSequence)recordCreator)) {
            result = false;
            logger.warn((Object)(msg1 + "the user, who created the record" + msg2));
        }
        if (StringUtils.isBlank((CharSequence)((String)((Object)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_REASON))))) {
            result = false;
            logger.warn((Object)(msg1 + "the reason for rejection" + msg2));
        }
        if (StringUtils.isBlank((CharSequence)((String)((Object)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_USER_ID))))) {
            result = false;
            logger.warn((Object)(msg1 + "the user, who rejected the record" + msg2));
        }
        if ((Date)this.nodeService.getProperty(record, PROP_RECORD_REJECTION_DATE) == null) {
            result = false;
            logger.warn((Object)(msg1 + "the date, when the record was rejected" + msg2));
        }
        return result;
    }

    private NodeRef getRMRoot(final NodeRef context) {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() {
                return RecordsManagementNotificationHelper.this.filePlanService.getFilePlan(context);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private String getGroupName(final NodeRef root) {
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() {
                Role role = RecordsManagementNotificationHelper.this.filePlanRoleService.getRole(root, RecordsManagementNotificationHelper.this.notificationRole);
                return role.getRoleGroupName();
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean doesGroupContainUsers(final String groupName) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Set users = RecordsManagementNotificationHelper.this.authorityService.getContainedAuthorities(AuthorityType.USER, groupName, true);
                return !users.isEmpty();
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private String getSiteName(final NodeRef root) {
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() {
                String result = RecordsManagementNotificationHelper.DEFAULT_SITE;
                SiteInfo siteInfo = RecordsManagementNotificationHelper.this.siteService.getSite(root);
                if (siteInfo != null) {
                    result = siteInfo.getShortName();
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }
}

