/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelSecurityService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class CommonRMTestUtils
implements RecordsManagementModel {
    public static final String DEFAULT_DISPOSITION_AUTHORITY = "disposition authority";
    public static final String DEFAULT_DISPOSITION_INSTRUCTIONS = "disposition instructions";
    public static final String DEFAULT_DISPOSITION_DESCRIPTION = "disposition action description";
    public static final String DEFAULT_EVENT_NAME = "case_closed";
    public static final String SEPARATION_EVENT_NAME = "separation";
    public static final String PERIOD_NONE = "none|0";
    public static final String PERIOD_IMMEDIATELY = "immediately|0";
    public static final String PERIOD_ONE_DAY = "day|1";
    public static final String PERIOD_FIVE_DAYS = "day|5";
    public static final String PERIOD_TEN_DAYS = "day|10";
    public static final String PERIOD_ONE_WEEK = "week|1";
    public static final String PERIOD_ONE_YEAR = "year|1";
    public static final String PERIOD_THREE_YEARS = "year|3";
    private DispositionService dispositionService;
    private NodeService nodeService;
    private ContentService contentService;
    private RecordsManagementActionService actionService;
    private ModelSecurityService modelSecurityService;
    private FilePlanRoleService filePlanRoleService;
    private CapabilityService capabilityService;
    private RecordService recordService;
    private HoldService holdService;

    public CommonRMTestUtils(ApplicationContext applicationContext) {
        this.dispositionService = (DispositionService)applicationContext.getBean("DispositionService");
        this.nodeService = (NodeService)applicationContext.getBean("NodeService");
        this.contentService = (ContentService)applicationContext.getBean("ContentService");
        this.actionService = (RecordsManagementActionService)applicationContext.getBean("RecordsManagementActionService");
        this.modelSecurityService = (ModelSecurityService)applicationContext.getBean("ModelSecurityService");
        this.filePlanRoleService = (FilePlanRoleService)applicationContext.getBean("FilePlanRoleService");
        this.capabilityService = (CapabilityService)applicationContext.getBean("CapabilityService");
        this.recordService = (RecordService)applicationContext.getBean("RecordService");
        this.holdService = (HoldService)applicationContext.getBean("HoldService");
    }

    public DispositionSchedule createBasicDispositionSchedule(NodeRef container) {
        return this.createBasicDispositionSchedule(container, DEFAULT_DISPOSITION_INSTRUCTIONS, DEFAULT_DISPOSITION_AUTHORITY, false, true);
    }

    public DispositionSchedule createBasicDispositionSchedule(NodeRef container, String dispositionInstructions, String dispositionAuthority, boolean isRecordLevel, boolean defaultDispositionActions) {
        return this.createDispositionSchedule(container, dispositionInstructions, dispositionAuthority, isRecordLevel, defaultDispositionActions, false);
    }

    public DispositionSchedule createDispositionSchedule(NodeRef container, String dispositionInstructions, String dispositionAuthority, boolean isRecordLevel, boolean defaultDispositionActions, boolean extendedDispositionSchedule) {
        return this.createDispositionSchedule(container, dispositionInstructions, dispositionAuthority, isRecordLevel, defaultDispositionActions, extendedDispositionSchedule, DEFAULT_EVENT_NAME);
    }

    public DispositionSchedule createDispositionSchedule(NodeRef container, String dispositionInstructions, String dispositionAuthority, boolean isRecordLevel, boolean defaultDispositionActions, boolean extendedDispositionSchedule, String defaultEvent) {
        HashMap<QName, Object> dsProps = new HashMap<QName, Object>(3);
        dsProps.put(PROP_DISPOSITION_AUTHORITY, dispositionAuthority);
        dsProps.put(PROP_DISPOSITION_INSTRUCTIONS, dispositionInstructions);
        dsProps.put(PROP_RECORD_LEVEL_DISPOSITION, isRecordLevel);
        DispositionSchedule dispositionSchedule = this.dispositionService.createDispositionSchedule(container, dsProps);
        if (defaultDispositionActions) {
            HashMap<QName, Object> adParams = new HashMap<QName, Object>(3);
            adParams.put(PROP_DISPOSITION_ACTION_NAME, "cutoff");
            adParams.put(PROP_DISPOSITION_DESCRIPTION, DEFAULT_DISPOSITION_DESCRIPTION);
            ArrayList<String> events = new ArrayList<String>(1);
            events.add(defaultEvent);
            adParams.put(PROP_DISPOSITION_EVENT, events);
            this.dispositionService.addDispositionActionDefinition(dispositionSchedule, adParams);
            if (extendedDispositionSchedule) {
                adParams = new HashMap(4);
                adParams.put(PROP_DISPOSITION_ACTION_NAME, "transfer");
                adParams.put(PROP_DISPOSITION_DESCRIPTION, DEFAULT_DISPOSITION_DESCRIPTION);
                adParams.put(PROP_DISPOSITION_PERIOD, PERIOD_IMMEDIATELY);
                adParams.put(PROP_DISPOSITION_LOCATION, "");
                this.dispositionService.addDispositionActionDefinition(dispositionSchedule, adParams);
            }
            adParams = new HashMap(3);
            adParams.put(PROP_DISPOSITION_ACTION_NAME, "destroy");
            adParams.put(PROP_DISPOSITION_DESCRIPTION, DEFAULT_DISPOSITION_DESCRIPTION);
            adParams.put(PROP_DISPOSITION_PERIOD, PERIOD_IMMEDIATELY);
            this.dispositionService.addDispositionActionDefinition(dispositionSchedule, adParams);
        }
        return dispositionSchedule;
    }

    public NodeRef createRecord(NodeRef recordFolder, String name) {
        return this.createRecord(recordFolder, name, null, "Some test content");
    }

    public NodeRef createRecord(NodeRef recordFolder, String name, String title) {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
        props.put(ContentModel.PROP_TITLE, (Serializable)((Object)title));
        return this.createRecord(recordFolder, name, props, "Some test content");
    }

    public NodeRef createRecord(NodeRef recordFolder, String name, Map<QName, Serializable> properties, String content) {
        NodeRef record = this.createRecordImpl(recordFolder, name, properties);
        ContentWriter writer = this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        return record;
    }

    public NodeRef createRecord(NodeRef recordFolder, String name, Map<QName, Serializable> properties, String mimetype, InputStream content) {
        NodeRef record = this.createRecordImpl(recordFolder, name, properties);
        ContentWriter writer = this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        return record;
    }

    private NodeRef createRecordImpl(NodeRef recordFolder, String name, Map<QName, Serializable> properties) {
        if (properties == null) {
            properties = new HashMap<QName, Serializable>(1);
        }
        if (!properties.containsKey(ContentModel.PROP_NAME)) {
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        }
        return this.nodeService.createNode(recordFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, properties).getChildRef();
    }

    public NodeRef createNonElectronicRecord(NodeRef recordFolder, String name, String title) {
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_TITLE, title);
        props.put(ContentModel.PROP_NAME, name);
        NodeRef record = this.nodeService.createNode(recordFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT, props).getChildRef();
        return record;
    }

    public void completeRecord(final NodeRef record) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                CommonRMTestUtils.this.modelSecurityService.setEnabled(false);
                try {
                    CommonRMTestUtils.this.nodeService.setProperty(record, RecordsManagementModel.PROP_DATE_FILED, (Serializable)new Date());
                    CommonRMTestUtils.this.nodeService.setProperty(record, ContentModel.PROP_TITLE, (Serializable)((Object)"titleValue"));
                    CommonRMTestUtils.this.actionService.executeRecordsManagementAction(record, "declareRecord");
                }
                finally {
                    CommonRMTestUtils.this.modelSecurityService.setEnabled(true);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void closeFolder(final NodeRef recordFolder) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                CommonRMTestUtils.this.modelSecurityService.setEnabled(false);
                try {
                    CommonRMTestUtils.this.actionService.executeRecordsManagementAction(recordFolder, "closeRecordFolder");
                }
                finally {
                    CommonRMTestUtils.this.modelSecurityService.setEnabled(true);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public Role createRole(NodeRef filePlan, String roleName, String ... capabilityNames) {
        HashSet<Capability> capabilities = new HashSet<Capability>(capabilityNames.length);
        for (String name : capabilityNames) {
            Capability capability = this.capabilityService.getCapability(name);
            if (capability == null) {
                throw new AlfrescoRuntimeException("capability " + name + " not found.");
            }
            capabilities.add(capability);
        }
        return this.filePlanRoleService.createRole(filePlan, roleName, roleName, capabilities);
    }

    public void completeEvent(NodeRef disposableItem, String eventName) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("eventName", eventName);
        this.actionService.executeRecordsManagementAction(disposableItem, "completeEvent", params);
    }

    public NodeRef createHold(NodeRef filePlan, String holdName, String holdReason) {
        return this.holdService.createHold(filePlan, holdName, holdReason, GUID.generate());
    }

    public void deleteHold(NodeRef nodeRef) {
        this.holdService.deleteHold(nodeRef);
    }

    public void addItemToHold(NodeRef holdNodeRef, NodeRef contentNodeRef) {
        this.holdService.addToHold(holdNodeRef, contentNodeRef);
    }

    public void removeItemFromHold(NodeRef holdNodeRef, NodeRef contentNodeRef) {
        this.holdService.removeFromHold(holdNodeRef, contentNodeRef);
    }

    public void removeItemsFromHolds(List<NodeRef> holdNodeRefs, List<NodeRef> contentNodeRef) {
        this.holdService.removeFromHolds(holdNodeRefs, contentNodeRef);
    }
}

