/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;

public class DispositionActionDefinitionImpl
implements DispositionActionDefinition,
RecordsManagementModel {
    private String name;
    private String description;
    private String label;
    private NodeService nodeService;
    private RecordsManagementActionService recordsManagementActionService;
    private RecordsManagementEventService recordsManagementEventService;
    private NodeRef dispositionActionNodeRef;
    private int index;
    private String ghostOnDestroy;

    public DispositionActionDefinitionImpl(RecordsManagementEventService recordsManagementEventService, RecordsManagementActionService recordsManagementActionService, NodeService nodeService, NodeRef nodeRef, int index) {
        this.recordsManagementEventService = recordsManagementEventService;
        this.recordsManagementActionService = recordsManagementActionService;
        this.nodeService = nodeService;
        this.dispositionActionNodeRef = nodeRef;
        this.index = index;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.dispositionActionNodeRef;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getId() {
        return this.dispositionActionNodeRef.getId();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_DESCRIPTION));
        }
        return this.description;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_ACTION_NAME));
        }
        return this.name;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            String name;
            this.label = name = this.getName();
            RecordsManagementAction action = this.recordsManagementActionService.getDispositionAction(name);
            if (action != null) {
                this.label = action.getLabel();
            }
        }
        return this.label;
    }

    @Override
    public Period getPeriod() {
        return (Period)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_PERIOD);
    }

    @Override
    public QName getPeriodProperty() {
        QName result = null;
        String value = (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_PERIOD_PROPERTY));
        if (value != null) {
            result = QName.createQName((String)value);
        }
        return result;
    }

    @Override
    public List<RecordsManagementEvent> getEvents() {
        ArrayList<RecordsManagementEvent> events = null;
        Collection eventNames = (Collection)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_EVENT));
        if (eventNames != null) {
            events = new ArrayList<RecordsManagementEvent>(eventNames.size());
            for (String eventName : eventNames) {
                RecordsManagementEvent event = this.recordsManagementEventService.getEvent(eventName);
                events.add(event);
            }
        } else {
            events = Collections.EMPTY_LIST;
        }
        return events;
    }

    @Override
    public boolean eligibleOnFirstCompleteEvent() {
        boolean result = true;
        String value = (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_EVENT_COMBINATION));
        if (value != null && value.equals("and")) {
            result = false;
        }
        return result;
    }

    @Override
    public String getLocation() {
        return (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_LOCATION));
    }

    @Override
    public String getGhostOnDestroy() {
        if (this.ghostOnDestroy == null) {
            this.ghostOnDestroy = (String)((Object)this.nodeService.getProperty(this.dispositionActionNodeRef, PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY));
        }
        return this.ghostOnDestroy;
    }
}

