/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.freeze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class FreezeServiceImpl
extends ServiceBaseImpl
implements FreezeService,
RecordsManagementModel {
    private static final String MSG_HOLD_NAME = "rm.hold.name";
    private FilePlanService filePlanService;
    private HoldService holdService;
    private RecordFolderService recordFolderService;
    private RecordService recordService;

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    protected FilePlanService getFilePlanService() {
        return this.filePlanService;
    }

    protected HoldService getHoldService() {
        return this.holdService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    @Override
    public boolean isFrozen(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.nodeService.hasAspect(nodeRef, ASPECT_FROZEN);
    }

    @Override
    @Deprecated
    public Set<NodeRef> getFrozen(NodeRef hold) {
        return new HashSet<NodeRef>(this.getHoldService().getHeld(hold));
    }

    @Override
    @Deprecated
    public NodeRef freeze(String reason, NodeRef nodeRef) {
        NodeRef hold = this.createHold(nodeRef, reason);
        this.getHoldService().addToHold(hold, nodeRef);
        return hold;
    }

    @Override
    @Deprecated
    public void freeze(NodeRef hold, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        this.getHoldService().addToHold(hold, nodeRef);
    }

    @Override
    @Deprecated
    public NodeRef freeze(String reason, Set<NodeRef> nodeRefs) {
        NodeRef hold = null;
        if (!nodeRefs.isEmpty()) {
            ArrayList<NodeRef> list = new ArrayList<NodeRef>(nodeRefs);
            hold = this.createHold((NodeRef)list.get(0), reason);
            this.getHoldService().addToHold(hold, list);
        }
        return hold;
    }

    @Override
    @Deprecated
    public void freeze(NodeRef hold, Set<NodeRef> nodeRefs) {
        ParameterCheck.mandatory((String)"hold", (Object)hold);
        ParameterCheck.mandatoryCollection((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.freeze(hold, nodeRef);
        }
    }

    @Override
    @Deprecated
    public void unFreeze(NodeRef nodeRef) {
        List<NodeRef> holds = this.getHoldService().heldBy(nodeRef, true);
        for (NodeRef hold : holds) {
            this.getHoldService().removeFromHold(hold, nodeRef);
        }
    }

    @Override
    @Deprecated
    public void unFreeze(Set<NodeRef> nodeRefs) {
        ParameterCheck.mandatoryCollection((String)"nodeRefs", nodeRefs);
        for (NodeRef nodeRef : nodeRefs) {
            this.unFreeze(nodeRef);
        }
    }

    @Override
    @Deprecated
    public void relinquish(NodeRef hold) {
        this.getHoldService().deleteHold(hold);
    }

    @Override
    @Deprecated
    public String getReason(NodeRef hold) {
        return this.getHoldService().getHoldReason(hold);
    }

    @Override
    @Deprecated
    public void updateReason(NodeRef hold, String reason) {
        this.getHoldService().setHoldReason(hold, reason);
    }

    @Override
    public Set<NodeRef> getHolds(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        return new HashSet<NodeRef>(this.getHoldService().getHolds(filePlan));
    }

    @Override
    public boolean hasFrozenChildren(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        boolean result = false;
        if (this.isRecordFolder(nodeRef) || this.instanceOf(nodeRef, ContentModel.TYPE_FOLDER) && !this.nodeService.hasAspect(nodeRef, SiteModel.ASPECT_SITE_CONTAINER)) {
            int heldCount = 0;
            if (this.nodeService.hasAspect(nodeRef, ASPECT_HELD_CHILDREN)) {
                heldCount = (Integer)this.getInternalNodeService().getProperty(nodeRef, PROP_HELD_CHILDREN_COUNT);
            } else {
                final TransactionService transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
                heldCount = (Integer)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                    public Integer doWork() {
                        return (Integer)transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            public Integer execute() throws Throwable {
                                int heldCount = 0;
                                List childAssocs = FreezeServiceImpl.this.getInternalNodeService().getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, null);
                                if (childAssocs != null && !childAssocs.isEmpty()) {
                                    for (ChildAssociationRef childAssociationRef : childAssocs) {
                                        NodeRef childRef = childAssociationRef.getChildRef();
                                        if (!childAssociationRef.isPrimary() || !FreezeServiceImpl.this.isFrozen(childRef)) continue;
                                        ++heldCount;
                                    }
                                }
                                HashMap<QName, Integer> props = new HashMap<QName, Integer>(1);
                                props.put(RecordsManagementModel.PROP_HELD_CHILDREN_COUNT, heldCount);
                                FreezeServiceImpl.this.getInternalNodeService().addAspect(nodeRef, RecordsManagementModel.ASPECT_HELD_CHILDREN, props);
                                return heldCount;
                            }
                        }, false, true);
                    }
                });
            }
            result = heldCount > 0;
        }
        return result;
    }

    @Override
    public Date getFreezeDate(NodeRef nodeRef) {
        Serializable property;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (this.isFrozen(nodeRef) && (property = this.nodeService.getProperty(nodeRef, PROP_FROZEN_AT)) != null) {
            return (Date)property;
        }
        return null;
    }

    @Override
    public String getFreezeInitiator(NodeRef nodeRef) {
        Serializable property;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (this.isFrozen(nodeRef) && (property = this.nodeService.getProperty(nodeRef, PROP_FROZEN_BY)) != null) {
            return (String)((Object)property);
        }
        return null;
    }

    private NodeRef createHold(NodeRef nodeRef, String reason) {
        NodeRef filePlan = this.getFilePlanService().getFilePlan(nodeRef);
        NodeRef holdContainer = this.getFilePlanService().getHoldContainer(filePlan);
        int nextCount = this.getNextCount(holdContainer);
        String holdName = I18NUtil.getMessage((String)MSG_HOLD_NAME) + " " + StringUtils.leftPad((String)Integer.toString(nextCount), (int)10, (String)"0");
        return this.getHoldService().createHold(filePlan, holdName, reason, null);
    }

    @Override
    public boolean isFrozenOrHasFrozenChildren(NodeRef nodeRef) {
        if (this.recordFolderService.isRecordFolder(nodeRef)) {
            return this.isFrozen(nodeRef) || this.hasFrozenChildren(nodeRef);
        }
        if (this.recordService.isRecord(nodeRef)) {
            return this.isFrozen(nodeRef);
        }
        return Boolean.FALSE;
    }
}

