/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript;

import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.jscript.ScriptRecordsManagmentNode;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.scripts.ScriptException;

public class ScriptRecordsManagmentService
extends BaseScopableProcessorExtension
implements RecordsManagementModel {
    private RecordsManagementServiceRegistry rmServices;
    private RecordsManagementNotificationHelper notificationHelper;

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry rmServices) {
        this.rmServices = rmServices;
    }

    public void setNotificationHelper(RecordsManagementNotificationHelper notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public ScriptRecordsManagmentNode getRecordsManagementNode(ScriptNode node) {
        ScriptRecordsManagmentNode result = null;
        if (!this.rmServices.getNodeService().hasAspect(node.getNodeRef(), ASPECT_FILE_PLAN_COMPONENT)) {
            throw new ScriptException("Node is not a records management node type.");
        }
        result = new ScriptRecordsManagmentNode(node.getNodeRef(), this.rmServices);
        return result;
    }

    public void setPermission(ScriptNode node, String permission, String authority) {
        FilePlanPermissionService filePlanPermissionService = this.rmServices.getFilePlanPermissionService();
        filePlanPermissionService.setPermission(node.getNodeRef(), authority, permission);
    }

    public void deletePermission(ScriptNode node, String permission, String authority) {
        FilePlanPermissionService filePlanPermissionService = this.rmServices.getFilePlanPermissionService();
        filePlanPermissionService.deletePermission(node.getNodeRef(), authority, permission);
    }

    public void sendSupersededNotification(ScriptNode record) {
        this.notificationHelper.recordSupersededEmailNotification(record.getNodeRef());
    }
}

