/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.AbstractDisposableItem;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

@BehaviourBean(defaultType="rma:recordCategory")
public class RecordCategoryType
extends AbstractDisposableItem
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnMoveNodePolicy {
    private static final List<QName> ACCEPTED_UNIQUE_CHILD_TYPES = new ArrayList<QName>();
    private static final List<QName> ACCEPTED_NON_UNIQUE_CHILD_TYPES = Arrays.asList(TYPE_RECORD_CATEGORY, TYPE_RECORD_FOLDER);
    protected VitalRecordService vitalRecordService;
    protected FilePlanPermissionService filePlanPermissionService;

    public void setVitalRecordService(VitalRecordService vitalRecordService) {
        this.vitalRecordService = vitalRecordService;
    }

    public void setFilePlanPermissionService(FilePlanPermissionService filePlanPermissionService) {
        this.filePlanPermissionService = filePlanPermissionService;
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean bNew) {
        QName childType = this.nodeService.getType(childAssocRef.getChildRef());
        if (childType.equals((Object)ContentModel.TYPE_FOLDER)) {
            this.nodeService.setType(childAssocRef.getChildRef(), TYPE_RECORD_FOLDER);
        }
        this.validateNewChildAssociation(childAssocRef.getParentRef(), childAssocRef.getChildRef(), ACCEPTED_UNIQUE_CHILD_TYPES, ACCEPTED_NON_UNIQUE_CHILD_TYPES);
        if (bNew) {
            this.recordFolderService.setupRecordFolder(childAssocRef.getChildRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Behaviour(kind=BehaviourKind.ASSOCIATION, policy="alf:onCreateChildAssociation", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateChildAssociationOnCommit(ChildAssociationRef childAssocRef, boolean bNew) {
        final NodeRef child = childAssocRef.getChildRef();
        this.behaviourFilter.disableBehaviour();
        try {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    if (RecordCategoryType.this.nodeService.exists(child)) {
                        RecordCategoryType.this.vitalRecordService.setupVitalRecordDefinition(child);
                    }
                    return null;
                }
            });
        }
        finally {
            this.behaviourFilter.enableBehaviour();
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateNode(final ChildAssociationRef childAssocRef) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"rma:recordCategory|alf:onCreateNode|this.onCreateNode()|TRANSATION_COMMIT");
        }
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordCategoryType.this.nodeService.exists(childAssocRef.getChildRef())) {
                    RecordCategoryType.this.filePlanPermissionService.setupRecordCategoryPermissions(childAssocRef.getChildRef());
                }
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (this.nodeService.getType(newChildAssocRef.getChildRef()).equals((Object)TYPE_RECORD_CATEGORY) && this.dispositionService.getDispositionSchedule(oldChildAssocRef.getParentRef()) != null) {
            this.reinitializeRecordFolders(newChildAssocRef);
        }
    }

    private void reinitializeRecordFolders(ChildAssociationRef childAssociationRef) {
        for (ChildAssociationRef newChildRef : this.nodeService.getChildAssocs(childAssociationRef.getChildRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)) {
            if (this.nodeService.getType(newChildRef.getChildRef()).equals((Object)TYPE_RECORD_CATEGORY)) {
                this.reinitializeRecordFolders(newChildRef);
                continue;
            }
            if (this.nodeService.getType(newChildRef.getChildRef()).equals((Object)ContentModel.TYPE_CONTENT)) continue;
            this.reinitializeRecordFolder(newChildRef);
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:getCopyCallback")
    public CopyBehaviourCallback onCopyRecordCategory(QName classRef, CopyDetails copyDetails) {
        return new DefaultCopyBehaviourCallback(){

            public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
                return !RecordCategoryType.this.nodeService.getType(copyDetails.getTargetParentNodeRef()).equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER);
            }
        };
    }
}

