/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.AuditableActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.action.dm.RecordActionUtils;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DeclareAsVersionRecordAction
extends AuditableActionExecuterAbstractBase
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(DeclareAsVersionRecordAction.class);
    public static final String NAME = "declare-version-record";
    public static final String PARAM_FILE_PLAN = "file-plan";
    public static final String PARAM_PATH = "path";
    private static final String FILE_VERSION_RECORDS_CAPABILITY = "FileVersionRecords";
    private static final String SYNC_MODEL_1_0_URI = "http://www.alfresco.org/model/sync/1.0";
    private static final QName ASPECT_SYNCED = QName.createQName((String)"http://www.alfresco.org/model/sync/1.0", (String)"synced");
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private DictionaryService dictionaryService;
    private RecordableVersionService recordableVersionService;
    private AuthenticationUtil authenticationUtil;
    private RecordService recordService;
    private CapabilityService capabilityService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRecordableVersionService(RecordableVersionService recordableVersionService) {
        this.recordableVersionService = recordableVersionService;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Can not declare version as record, because " + actionedUponNodeRef.toString() + " does not exist."));
            return;
        } else if (!this.dictionaryService.isSubClass(this.nodeService.getType(actionedUponNodeRef), ContentModel.TYPE_CONTENT)) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Can not declare version as record, because " + actionedUponNodeRef.toString() + " is not a supported type."));
            return;
        } else {
            if (!this.isActionEligible(actionedUponNodeRef)) return;
            NodeRef filePlan = (NodeRef)action.getParameterValue(PARAM_FILE_PLAN);
            if (filePlan == null) {
                filePlan = RecordActionUtils.getDefaultFilePlan(this.authenticationUtil, this.filePlanService, NAME);
            } else if (!this.filePlanService.isFilePlan(filePlan)) {
                if (!logger.isDebugEnabled()) throw new AlfrescoRuntimeException("Can not declare version record, because the provided file plan node reference is not a file plan.");
                logger.debug((Object)"Can not declare version record, because the provided file plan node reference is not a file plan.");
                throw new AlfrescoRuntimeException("Can not declare version record, because the provided file plan node reference is not a file plan.");
            }
            NodeRef destinationRecordFolder = null;
            String pathParameter = (String)((Object)action.getParameterValue(PARAM_PATH));
            if (pathParameter != null && !pathParameter.isEmpty()) {
                RecordActionUtils.Services services = new RecordActionUtils.Services(this.nodeService, this.filePlanService, this.authenticationUtil);
                destinationRecordFolder = RecordActionUtils.resolvePath(services, filePlan, pathParameter, NAME);
            }
            if (destinationRecordFolder != null) {
                boolean hasCapability = this.capabilityService.hasCapability(destinationRecordFolder, FILE_VERSION_RECORDS_CAPABILITY);
                if (!hasCapability) throw new AccessDeniedException(I18NUtil.getMessage((String)"permissions.err_access_denied"));
                NodeRef recordedVersion = this.recordableVersionService.createRecordFromLatestVersion(destinationRecordFolder, actionedUponNodeRef);
                this.recordService.file(recordedVersion);
                return;
            } else {
                this.recordableVersionService.createRecordFromLatestVersion(filePlan, actionedUponNodeRef);
            }
        }
    }

    protected void addParameterDefinitions(List<ParameterDefinition> params) {
        params.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_PATH, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_PATH)));
    }

    private boolean isActionEligible(NodeRef actionedUponNodeRef) {
        HashMap<QName, String> mappedAspects = new HashMap<QName, String>();
        mappedAspects.put(ASPECT_RECORD, " is already a record.");
        mappedAspects.put(ContentModel.ASPECT_WORKING_COPY, " is a working copy.");
        mappedAspects.put(ASPECT_RECORD_REJECTION_DETAILS, " has previously been rejected.");
        mappedAspects.put(ASPECT_SYNCED, " is synched content.");
        for (Map.Entry aspect : mappedAspects.entrySet()) {
            if (!this.nodeService.hasAspect(actionedUponNodeRef, (QName)aspect.getKey())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can not declare version record, because " + actionedUponNodeRef.toString() + (String)aspect.getValue()));
            }
            return false;
        }
        if (!this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can not declare version record, because " + actionedUponNodeRef.toString() + " does not have the versionable aspect applied."));
            }
            return false;
        }
        return true;
    }
}

