/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelAccessDeniedException;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelSecurityService;
import org.alfresco.module.org_alfresco_module_rm.model.security.ProtectedAspect;
import org.alfresco.module.org_alfresco_module_rm.model.security.ProtectedModelArtifact;
import org.alfresco.module.org_alfresco_module_rm.model.security.ProtectedProperty;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

@BehaviourBean
public class ModelSecurityServiceImpl
extends BaseBehaviourBean
implements ModelSecurityService,
NodeServicePolicies.BeforeAddAspectPolicy,
NodeServicePolicies.BeforeRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private boolean enabled = true;
    private NamespaceService namespaceService;
    private FilePlanService filePlanService;
    private Map<QName, ProtectedProperty> protectedProperties = new HashMap<QName, ProtectedProperty>(21);
    private Map<QName, ProtectedAspect> protectedAspects = new HashMap<QName, ProtectedAspect>(21);

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Override
    public void disable() {
        this.getBehaviour("beforeAddAspect").disable();
        this.getBehaviour("beforeRemoveAspect").disable();
        this.getBehaviour("onUpdateProperties").disable();
    }

    @Override
    public void enable() {
        this.getBehaviour("beforeAddAspect").enable();
        this.getBehaviour("beforeRemoveAspect").enable();
        this.getBehaviour("onUpdateProperties").enable();
    }

    @Override
    public void register(ProtectedModelArtifact artifact) {
        if (artifact instanceof ProtectedProperty) {
            this.protectedProperties.put(artifact.getQName(), (ProtectedProperty)artifact);
        } else if (artifact instanceof ProtectedAspect) {
            this.protectedAspects.put(artifact.getQName(), (ProtectedAspect)artifact);
        }
    }

    @Override
    public boolean isProtectedProperty(QName property) {
        return this.protectedProperties.containsKey(property);
    }

    @Override
    public Set<QName> getProtectedProperties() {
        return Collections.unmodifiableSet(this.protectedProperties.keySet());
    }

    @Override
    public ProtectedProperty getProtectedProperty(QName name) {
        return this.protectedProperties.get(name);
    }

    @Override
    public boolean canEditProtectedProperty(NodeRef nodeRef, QName property) {
        boolean result = false;
        ProtectedProperty artifact = this.getProtectedProperty(property);
        result = artifact == null ? true : this.canEdit(nodeRef, artifact);
        return result;
    }

    private boolean canEdit(NodeRef nodeRef, ProtectedModelArtifact artifact) {
        boolean result = false;
        NodeRef filePlan = this.filePlanService.getFilePlan(nodeRef);
        if (filePlan != null) {
            for (Capability capability : artifact.getCapabilities()) {
                if (!capability.hasPermission(nodeRef).equals((Object)AccessStatus.ALLOWED)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isProtectedAspect(QName aspect) {
        return this.protectedAspects.containsKey(aspect);
    }

    @Override
    public Set<QName> getProtectedAspects() {
        return Collections.unmodifiableSet(this.protectedAspects.keySet());
    }

    @Override
    public ProtectedAspect getProtectedAspect(QName name) {
        return this.protectedAspects.get(name);
    }

    @Override
    public boolean canEditProtectedAspect(NodeRef nodeRef, QName aspect) {
        boolean result = false;
        ProtectedAspect artifact = this.getProtectedAspect(aspect);
        result = artifact == null ? true : this.canEdit(nodeRef, artifact);
        return result;
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, name="beforeAddAspect")
    public void beforeAddAspect(NodeRef nodeRef, QName aspect) {
        if (this.enabled && AuthenticationUtil.getFullyAuthenticatedUser() != null && !AuthenticationUtil.isRunAsUserTheSystemUser() && this.isProtectedAspect(aspect) && this.nodeService.exists(nodeRef) && !this.canEditProtectedAspect(nodeRef, aspect)) {
            throw new ModelAccessDeniedException("The user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have the permission to add the protected aspect " + aspect.toPrefixString((NamespacePrefixResolver)this.namespaceService) + " to the node " + nodeRef.toString());
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, name="beforeRemoveAspect")
    public void beforeRemoveAspect(NodeRef nodeRef, QName aspect) {
        if (this.enabled && AuthenticationUtil.getFullyAuthenticatedUser() != null && !AuthenticationUtil.isRunAsUserTheSystemUser() && this.isProtectedAspect(aspect) && this.nodeService.exists(nodeRef) && !this.canEditProtectedAspect(nodeRef, aspect)) {
            throw new ModelAccessDeniedException("The user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have the permission to remove the protected aspect " + aspect.toPrefixString((NamespacePrefixResolver)this.namespaceService) + " from the node " + nodeRef.toString());
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, name="onUpdateProperties")
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.enabled && AuthenticationUtil.getFullyAuthenticatedUser() != null && !AuthenticationUtil.isRunAsUserTheSystemUser() && this.nodeService.exists(nodeRef)) {
            for (Map.Entry<QName, Serializable> entry : after.entrySet()) {
                QName property = entry.getKey();
                if (!this.isProtectedProperty(property)) continue;
                if (before == null || before.isEmpty() || before.get(property) == null) {
                    return;
                }
                if (EqualsHelper.nullSafeEquals((Object)before.get(property), (Object)entry.getValue()) || this.canEditProtectedProperty(nodeRef, property)) continue;
                throw new ModelAccessDeniedException("The user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have the permission to edit the protected property " + property.toPrefixString((NamespacePrefixResolver)this.namespaceService) + " on the node " + nodeRef.toString());
            }
        }
    }
}

