/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import junit.framework.TestCase;
import org.alfresco.model.QuickShareModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.security.AccessStatus;

public class CreateInplaceRecordTest
extends BaseRMTestCase {
    private QuickShareService quickShareService;

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
        this.quickShareService = (QuickShareService)this.applicationContext.getBean("quickShareService");
    }

    public void testCreateInplaceRecordFromCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                TestCase.assertFalse((String)"The document should not be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateInplaceRecordTest.this.recordService.createRecord(CreateInplaceRecordTest.this.filePlan, CreateInplaceRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
            }

            @Override
            public void then() {
                TestCase.assertTrue((String)"The document should now be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "Filing"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "ReadRecords"));
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "Filing"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "ReadRecords"));
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmConsumer);
            }
        });
    }

    public void testFileInplaceRecordFromCollabSite() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                TestCase.assertFalse((String)"The document should not be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateInplaceRecordTest.this.recordService.createRecord(CreateInplaceRecordTest.this.filePlan, CreateInplaceRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
                TestCase.assertTrue((String)"The document should be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                TestCase.assertFalse((String)"The record should not be filed", (boolean)CreateInplaceRecordTest.this.recordService.isFiled(CreateInplaceRecordTest.this.dmDocument));
            }

            @Override
            public void when() throws FileExistsException, FileNotFoundException {
                CreateInplaceRecordTest.this.fileFolderService.move(CreateInplaceRecordTest.this.dmDocument, CreateInplaceRecordTest.this.rmFolder, null);
            }

            @Override
            public void then() {
                TestCase.assertTrue((String)"The document should be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                TestCase.assertTrue((String)"The record hsould be filed", (boolean)CreateInplaceRecordTest.this.recordService.isFiled(CreateInplaceRecordTest.this.dmDocument));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "Filing"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "ReadRecords"));
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "Filing"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateInplaceRecordTest.this.permissionService.hasPermission(CreateInplaceRecordTest.this.dmDocument, "ReadRecords"));
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmConsumer);
            }
        });
    }

    public void testCreateInplaceRecordFromCollabSiteRemovesSharedLink() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                TestCase.assertFalse((String)"The document should not be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                CreateInplaceRecordTest.this.quickShareService.shareContent(CreateInplaceRecordTest.this.dmDocument);
                TestCase.assertTrue((String)"The document is shared", (boolean)CreateInplaceRecordTest.this.nodeService.hasAspect(CreateInplaceRecordTest.this.dmDocument, QuickShareModel.ASPECT_QSHARE));
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateInplaceRecordTest.this.recordService.createRecord(CreateInplaceRecordTest.this.filePlan, CreateInplaceRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
            }

            @Override
            public void then() {
                TestCase.assertTrue((String)"The document should now be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                TestCase.assertFalse((String)"The document should not be shared anymore", (boolean)CreateInplaceRecordTest.this.nodeService.hasAspect(CreateInplaceRecordTest.this.dmDocument, QuickShareModel.ASPECT_QSHARE));
            }
        });
    }

    public void testRecordsFromCollabSiteCannotBeShared() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(IntegrityException.class){

            @Override
            public void given() {
                TestCase.assertFalse((String)"The document should not be a record", (boolean)CreateInplaceRecordTest.this.recordService.isRecord(CreateInplaceRecordTest.this.dmDocument));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateInplaceRecordTest.this.recordService.createRecord(CreateInplaceRecordTest.this.filePlan, CreateInplaceRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)CreateInplaceRecordTest.this.dmCollaborator);
            }

            @Override
            public void when() {
                CreateInplaceRecordTest.this.quickShareService.shareContent(CreateInplaceRecordTest.this.dmDocument);
            }

            @Override
            public void after() {
                TestCase.assertFalse((String)"The document should not be shared", (boolean)CreateInplaceRecordTest.this.nodeService.hasAspect(CreateInplaceRecordTest.this.dmDocument, QuickShareModel.ASPECT_QSHARE));
            }
        });
    }
}

