/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.capabilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.CapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.DeclarativeCapability;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.DeclarativeCompositeCapability;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.extensions.webscripts.GUID;

public class DeclarativeCapabilityTest
extends BaseRMTestCase {
    private NodeRef record;
    private NodeRef declaredRecord;
    private NodeRef undeclaredRecord;
    private NodeRef recordFolderContainsFrozen;
    private NodeRef frozenRecord;
    private NodeRef frozenRecord2;
    private NodeRef frozenRecordFolder;
    private NodeRef closedFolder;
    private NodeRef moveToFolder;
    private NodeRef moveToCategory;
    private NodeRef hold;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "record.txt");
        this.declaredRecord = this.utils.createRecord(this.rmFolder, "declaredRecord.txt");
        this.undeclaredRecord = this.utils.createRecord(this.rmFolder, "undeclaredRecord.txt");
        this.closedFolder = this.recordFolderService.createRecordFolder(this.rmContainer, "closedFolder");
        this.utils.closeFolder(this.closedFolder);
        this.recordFolderContainsFrozen = this.recordFolderService.createRecordFolder(this.rmContainer, "containsFrozen");
        this.frozenRecord = this.utils.createRecord(this.rmFolder, "frozenRecord.txt");
        this.frozenRecord2 = this.utils.createRecord(this.recordFolderContainsFrozen, "frozen2.txt");
        this.frozenRecordFolder = this.recordFolderService.createRecordFolder(this.rmContainer, "frozenRecordFolder");
        this.moveToFolder = this.recordFolderService.createRecordFolder(this.rmContainer, "moveToFolder");
        this.moveToCategory = this.filePlanService.createRecordCategory(this.rmContainer, "moveToCategory");
    }

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                DeclarativeCapabilityTest.this.utils.completeRecord(DeclarativeCapabilityTest.this.declaredRecord);
                DeclarativeCapabilityTest.this.utils.completeRecord(DeclarativeCapabilityTest.this.frozenRecord);
                DeclarativeCapabilityTest.this.utils.completeRecord(DeclarativeCapabilityTest.this.frozenRecord2);
                DeclarativeCapabilityTest.this.hold = DeclarativeCapabilityTest.this.holdService.createHold(DeclarativeCapabilityTest.this.filePlan, GUID.generate(), "reason", "description");
                DeclarativeCapabilityTest.this.holdService.addToHold(DeclarativeCapabilityTest.this.hold, DeclarativeCapabilityTest.this.frozenRecord);
                DeclarativeCapabilityTest.this.holdService.addToHold(DeclarativeCapabilityTest.this.hold, DeclarativeCapabilityTest.this.frozenRecordFolder);
                DeclarativeCapabilityTest.this.holdService.addToHold(DeclarativeCapabilityTest.this.hold, DeclarativeCapabilityTest.this.frozenRecord2);
                return null;
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        for (String user : this.testUsers) {
            this.filePlanPermissionService.setPermission(this.rmFolder, user, "Filing");
            this.filePlanPermissionService.setPermission(this.rmContainer, user, "ReadRecords");
            this.filePlanPermissionService.setPermission(this.moveToFolder, user, "ReadRecords");
            this.filePlanPermissionService.setPermission(this.moveToCategory, user, "ReadRecords");
        }
    }

    public void testDeclarativeCapabilities() {
        Set capabilities = this.capabilityService.getCapabilities();
        for (Capability capability : capabilities) {
            if (!(capability instanceof DeclarativeCapability) || capability instanceof DeclarativeCompositeCapability || capability.isPrivate() || capability.getName().equals("MoveRecords") || capability.getName().equals("DeleteLinks") || capability.getName().equals("ChangeOrDeleteReferences")) continue;
            this.testDeclarativeCapability((DeclarativeCapability)capability);
        }
    }

    private void testDeclarativeCapability(DeclarativeCapability capability) {
        for (String user : this.testUsers) {
            this.testDeclarativeCapability(capability, user, this.filePlan);
            this.testDeclarativeCapability(capability, user, this.rmContainer);
            this.testDeclarativeCapability(capability, user, this.rmFolder);
            this.testDeclarativeCapability(capability, user, this.record);
        }
    }

    private void testDeclarativeCapability(final DeclarativeCapability capability, final String userName, final NodeRef filePlanComponent) {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                AccessStatus accessStatus = capability.hasPermission(filePlanComponent);
                Set roles = DeclarativeCapabilityTest.this.filePlanRoleService.getRolesByUser(DeclarativeCapabilityTest.this.filePlan, userName);
                if (roles.isEmpty()) {
                    TestCase.assertEquals((String)("User " + userName + " has no RM role so we expect access to be denied for capability " + capability.getName()), (Object)AccessStatus.DENIED, (Object)accessStatus);
                } else {
                    FilePlanComponentKind actualKind = DeclarativeCapabilityTest.this.filePlanService.getFilePlanComponentKind(filePlanComponent);
                    List kinds = capability.getKinds();
                    if (kinds == null || kinds.contains(actualKind.toString())) {
                        Map conditions = capability.getConditions();
                        boolean conditionResult = DeclarativeCapabilityTest.this.getConditionResult(filePlanComponent, conditions);
                        TestCase.assertEquals((String)"User is expected to only have one role.", (int)1, (int)roles.size());
                        Role role = (Role)new ArrayList(roles).get(0);
                        TestCase.assertNotNull((Object)role);
                        Set roleCapabilities = role.getCapabilities();
                        if (roleCapabilities.contains(capability) && conditionResult) {
                            TestCase.assertEquals((String)("User " + userName + " has the role " + role.getDisplayLabel() + " so we expect access to be allowed for capability " + capability.getName() + " on the object " + (String)((Object)DeclarativeCapabilityTest.this.nodeService.getProperty(filePlanComponent, ContentModel.PROP_NAME))), (Object)AccessStatus.ALLOWED, (Object)accessStatus);
                        } else {
                            TestCase.assertEquals((String)("User " + userName + " has the role " + role.getDisplayLabel() + " so we expect access to be denied for capability " + capability.getName()), (Object)AccessStatus.DENIED, (Object)accessStatus);
                        }
                    } else {
                        TestCase.assertEquals((String)("NodeRef is of kind" + String.valueOf(actualKind) + " so we expect access to be denied for capability " + capability.getName()), (Object)AccessStatus.DENIED, (Object)accessStatus);
                    }
                }
                return null;
            }
        }, userName);
    }

    private boolean getConditionResult(NodeRef nodeRef, Map<String, Boolean> conditions) {
        boolean result = true;
        if (conditions != null && conditions.size() != 0) {
            for (Map.Entry<String, Boolean> entry : conditions.entrySet()) {
                CapabilityCondition condition = (CapabilityCondition)this.applicationContext.getBean(entry.getKey());
                DeclarativeCapabilityTest.assertNotNull((String)"Invalid condition name.", (Object)condition);
                boolean actual = condition.evaluate(nodeRef);
                if (actual == entry.getValue()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void testCreateRecordCapability() {
        final Capability capability = this.capabilityService.getCapability("CreateRecords");
        DeclarativeCapabilityTest.assertNotNull((Object)capability);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                return null;
            }
        }, this.rmUserName);
    }

    public void testMoveRecordCapability() {
        final Capability capability = this.capabilityService.getCapability("MoveRecords");
        DeclarativeCapabilityTest.assertNotNull((Object)capability);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.record, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.declaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.undeclaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.frozenRecord, DeclarativeCapabilityTest.this.moveToFolder));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                for (String user : DeclarativeCapabilityTest.this.testUsers) {
                    DeclarativeCapabilityTest.this.filePlanPermissionService.setPermission(DeclarativeCapabilityTest.this.moveToFolder, user, "Filing");
                }
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)1, (int)capability.evaluate(DeclarativeCapabilityTest.this.record, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)1, (int)capability.evaluate(DeclarativeCapabilityTest.this.declaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)1, (int)capability.evaluate(DeclarativeCapabilityTest.this.undeclaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.frozenRecord, DeclarativeCapabilityTest.this.moveToFolder));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.record, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.declaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.undeclaredRecord, DeclarativeCapabilityTest.this.moveToFolder));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.frozenRecord, DeclarativeCapabilityTest.this.moveToFolder));
                return null;
            }
        }, this.rmUserName);
    }

    public void testMoveRecordFolderCapability() {
        final Capability capability = this.capabilityService.getCapability("MoveRecordFolder");
        DeclarativeCapabilityTest.assertNotNull((Object)capability);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.rmFolder, DeclarativeCapabilityTest.this.moveToCategory));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                for (String user : DeclarativeCapabilityTest.this.testUsers) {
                    DeclarativeCapabilityTest.this.filePlanPermissionService.setPermission(DeclarativeCapabilityTest.this.moveToCategory, user, "Filing");
                }
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)1, (int)capability.evaluate(DeclarativeCapabilityTest.this.rmFolder, DeclarativeCapabilityTest.this.moveToCategory));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.declaredRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecordFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.recordFolderContainsFrozen));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.frozenRecord));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.closedFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(DeclarativeCapabilityTest.this.undeclaredRecord));
                TestCase.assertEquals((int)-1, (int)capability.evaluate(DeclarativeCapabilityTest.this.rmFolder, DeclarativeCapabilityTest.this.moveToCategory));
                return null;
            }
        }, this.rmUserName);
    }
}

