/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.event;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.SimpleRecordsManagementEventTypeImpl;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

@BehaviourBean
public class OnReferencedRecordActionedUpon
extends SimpleRecordsManagementEventTypeImpl
implements RecordsManagementModel,
RecordsManagementPolicies.BeforeRMActionExecution {
    private DispositionService dispositionService;
    private RecordsManagementActionService recordsManagementActionService;
    private NodeService nodeService;
    private RecordService recordService;
    private RecordFolderService recordFolderService;
    private String actionName;
    private QName reference;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService recordsManagementActionService) {
        this.recordsManagementActionService = recordsManagementActionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setReferenceName(String reference) {
        this.reference = QName.createQName((String)reference);
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public boolean isAutomaticEvent() {
        return true;
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, type="rma:filePlanComponent", notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeRMActionExecution(final NodeRef nodeRef, final String name, Map<String, Serializable> parameters) {
        AuthenticationUtil.RunAsWork<Object> work = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                if (OnReferencedRecordActionedUpon.this.nodeService.exists(nodeRef) && name.equals(OnReferencedRecordActionedUpon.this.actionName)) {
                    QName type = OnReferencedRecordActionedUpon.this.nodeService.getType(nodeRef);
                    if (RecordsManagementModel.TYPE_TRANSFER.equals((Object)type)) {
                        List assocs = OnReferencedRecordActionedUpon.this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
                        for (ChildAssociationRef assoc : assocs) {
                            OnReferencedRecordActionedUpon.this.processRecordFolder(assoc.getChildRef());
                        }
                    } else {
                        OnReferencedRecordActionedUpon.this.processRecordFolder(nodeRef);
                    }
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminUserName());
    }

    private void processRecordFolder(NodeRef recordFolder) {
        if (this.recordService.isRecord(recordFolder)) {
            this.processRecord(recordFolder);
        } else if (this.recordFolderService.isRecordFolder(recordFolder)) {
            for (NodeRef record : this.recordService.getRecords(recordFolder)) {
                this.processRecord(record);
            }
        }
    }

    private void processRecord(NodeRef record) {
        List fromAssocs = this.nodeService.getTargetAssocs(record, RegexQNamePattern.MATCH_ALL);
        for (AssociationRef fromAssoc : fromAssocs) {
            if (!this.reference.equals((Object)fromAssoc.getTypeQName())) continue;
            NodeRef nodeRef = fromAssoc.getTargetRef();
            this.doEventComplete(nodeRef);
        }
        List toAssocs = this.nodeService.getSourceAssocs(record, RegexQNamePattern.MATCH_ALL);
        for (AssociationRef toAssoc : toAssocs) {
            if (!this.reference.equals((Object)toAssoc.getTypeQName())) continue;
            NodeRef nodeRef = toAssoc.getSourceRef();
            this.doEventComplete(nodeRef);
        }
    }

    private void doEventComplete(NodeRef nodeRef) {
        DispositionAction da = this.dispositionService.getNextDispositionAction(nodeRef);
        if (da != null) {
            List<EventCompletionDetails> events = da.getEventCompletionDetails();
            for (EventCompletionDetails event : events) {
                RecordsManagementEvent rmEvent = this.getRecordsManagementEventService().getEvent(event.getEventName());
                if (event.isEventComplete() || !rmEvent.getType().equals(this.getName())) continue;
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(3);
                params.put("eventName", (Serializable)((Object)event.getEventName()));
                params.put("eventCompletedBy", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                params.put("eventCompletedAt", new Date());
                this.recordsManagementActionService.executeRecordsManagementAction(nodeRef, "completeEvent", params);
                break;
            }
        }
    }
}

