/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.version;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.util.AlfrescoTransactionSupport;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean
public class ExtendedVersionableAspect
implements NodeServicePolicies.OnSetNodeTypePolicy {
    private static final String MSG_AUTO_VERSION = "create_version.auto_version";
    private static final String KEY_VERSIONED_NODEREFS = "versioned_noderefs";
    private NodeService nodeService;
    private VersionService versionService;
    private LockService lockService;
    private AlfrescoTransactionSupport alfrescoTransactionSupport;
    private AuthenticationUtil authenticationUtil;
    private boolean isAutoVersionOnTypeChange = false;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setAlfrescoTransactionSupport(AlfrescoTransactionSupport alfrescoTransactionSupport) {
        this.alfrescoTransactionSupport = alfrescoTransactionSupport;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setAutoVersionOnTypeChange(boolean isAutoVersionOnTypeChange) {
        this.isAutoVersionOnTypeChange = isAutoVersionOnTypeChange;
    }

    @Behaviour(type="cm:versionable", kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onSetNodeType(NodeRef nodeRef, QName oldType, QName newType) {
        Map versionedNodeRefs;
        if (this.isAutoVersionOnTypeChange && this.nodeService.exists(nodeRef) && !this.lockService.isLockedAndReadOnly(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY) && ((versionedNodeRefs = (Map)this.alfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS)) == null || !versionedNodeRefs.containsKey(nodeRef))) {
            boolean autoVersion = false;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION);
            if (value != null) {
                autoVersion = value;
            }
            if (autoVersion) {
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_AUTO_VERSION)));
                this.createVersionImpl(nodeRef, versionProperties);
            }
        }
    }

    private void createVersionImpl(final NodeRef nodeRef, final Map<String, Serializable> versionProperties) {
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ExtendedVersionableAspect.this.recordCreateVersion(nodeRef, null);
                ExtendedVersionableAspect.this.versionService.createVersion(nodeRef, versionProperties);
                return null;
            }
        });
    }

    private void recordCreateVersion(NodeRef versionableNode, Version version) {
        HashMap<NodeRef, NodeRef> versionedNodeRefs = (HashMap<NodeRef, NodeRef>)this.alfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS);
        if (versionedNodeRefs == null) {
            versionedNodeRefs = new HashMap<NodeRef, NodeRef>();
            this.alfrescoTransactionSupport.bindResource(KEY_VERSIONED_NODEREFS, versionedNodeRefs);
        }
        versionedNodeRefs.put(versionableNode, versionableNode);
    }
}

