/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServicePolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class DeleteHoldTest
extends BaseRMTestCase
implements HoldServicePolicies.BeforeDeleteHoldPolicy,
HoldServicePolicies.OnDeleteHoldPolicy {
    protected static final String HOLD1_NAME = "hold one";
    protected static final String HOLD2_NAME = "hold two";
    protected static final String HOLD1_REASON = "I have my reasons";
    protected static final String HOLD2_REASON = "secrets are everything";
    protected static final String HOLD1_DESC = "but I'll not describe them here!";
    protected static final String HOLD2_DESC = "no then! that's just not on!";
    private boolean beforeDeleteHoldFlag = false;
    private boolean onDeleteHoldFlag = false;

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    protected NodeRef createAndCheckHold() {
        NodeRef hold = this.holdService.createHold(this.filePlan, HOLD1_NAME, HOLD1_REASON, HOLD1_DESC);
        DeleteHoldTest.assertNotNull((Object)hold);
        return hold;
    }

    protected List<NodeRef> createAndCheckHolds() {
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
        holds.add(this.createAndCheckHold());
        NodeRef hold2 = this.holdService.createHold(this.filePlan, HOLD2_NAME, HOLD2_REASON, HOLD2_DESC);
        DeleteHoldTest.assertNotNull((Object)hold2);
        holds.add(hold2);
        DeleteHoldTest.assertEquals((int)2, (int)holds.size());
        return holds;
    }

    public void testDeleteHoldBehaviourForRecordFolder() {
        final NodeRef hold1 = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef newHold = DeleteHoldTest.this.createAndCheckHold();
                DeleteHoldTest.this.holdService.addToHold(newHold, DeleteHoldTest.this.rmFolder);
                return newHold;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                List frozenNodes = DeleteHoldTest.this.holdService.getHeld(hold1);
                TestCase.assertNotNull((Object)frozenNodes);
                TestCase.assertEquals((int)1, (int)frozenNodes.size());
                TestCase.assertEquals((Object)DeleteHoldTest.this.rmFolder, frozenNodes.get(0));
                DeleteHoldTest.this.holdService.deleteHold(hold1);
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                TestCase.assertNull((Object)DeleteHoldTest.this.holdService.getHold(DeleteHoldTest.this.filePlan, DeleteHoldTest.HOLD1_NAME));
                return null;
            }
        });
    }

    public void testDeleteHoldBehaviourForMultipleHolds() {
        final List<NodeRef> holds = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<List<NodeRef>>(){

            public List<NodeRef> run() throws Exception {
                return DeleteHoldTest.this.createAndCheckHolds();
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef hold1 = (NodeRef)holds.get(0);
                NodeRef hold2 = (NodeRef)holds.get(1);
                DeleteHoldTest.this.holdService.addToHold(hold1, DeleteHoldTest.this.rmFolder);
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                List frozenNodes = DeleteHoldTest.this.holdService.getHeld(hold1);
                TestCase.assertNotNull((Object)frozenNodes);
                TestCase.assertEquals((int)1, (int)frozenNodes.size());
                TestCase.assertEquals((Object)DeleteHoldTest.this.rmFolder, frozenNodes.get(0));
                DeleteHoldTest.this.holdService.addToHold(hold2, DeleteHoldTest.this.recordOne);
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef hold1 = (NodeRef)holds.get(0);
                NodeRef hold2 = (NodeRef)holds.get(1);
                DeleteHoldTest.this.holdService.deleteHold(hold1);
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertTrue((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                TestCase.assertNull((Object)DeleteHoldTest.this.holdService.getHold(DeleteHoldTest.this.filePlan, DeleteHoldTest.HOLD1_NAME));
                DeleteHoldTest.this.holdService.deleteHold(hold2);
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.rmFolder));
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordOne));
                TestCase.assertFalse((boolean)DeleteHoldTest.this.freezeService.isFrozen(DeleteHoldTest.this.recordDeclaredOne));
                TestCase.assertNull((Object)DeleteHoldTest.this.holdService.getHold(DeleteHoldTest.this.filePlan, DeleteHoldTest.HOLD2_NAME));
                return null;
            }
        });
    }

    public void testHeldByNothing() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DeleteHoldTest.this.createAndCheckHolds();
                ArrayList holds = new ArrayList();
                holds.addAll(DeleteHoldTest.this.holdService.heldBy(DeleteHoldTest.this.rmFolder, true));
                TestCase.assertTrue((boolean)holds.isEmpty());
                holds.clear();
                holds.addAll(DeleteHoldTest.this.holdService.heldBy(DeleteHoldTest.this.rmFolder, false));
                TestCase.assertEquals((int)2, (int)holds.size());
                holds.clear();
                holds.addAll(DeleteHoldTest.this.holdService.heldBy(DeleteHoldTest.this.recordOne, true));
                TestCase.assertTrue((boolean)holds.isEmpty());
                holds.clear();
                holds.addAll(DeleteHoldTest.this.holdService.heldBy(DeleteHoldTest.this.recordOne, false));
                TestCase.assertEquals((int)2, (int)holds.size());
                return null;
            }
        });
    }

    public void testPolicyNotificationForDeleteHold() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            BehaviourDefinition<ClassBehaviourBinding> beforeDeleteHoldBehaviour;
            BehaviourDefinition<ClassBehaviourBinding> onDeleteHoldBehaviour;
            NodeRef hold;

            @Override
            public void given() {
                this.beforeDeleteHoldBehaviour = DeleteHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.BeforeDeleteHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)DeleteHoldTest.this, "beforeDeleteHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                this.onDeleteHoldBehaviour = DeleteHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.OnDeleteHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)DeleteHoldTest.this, "onDeleteHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                this.hold = DeleteHoldTest.this.holdService.createHold(DeleteHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                TestCase.assertFalse((boolean)DeleteHoldTest.this.beforeDeleteHoldFlag);
                TestCase.assertFalse((boolean)DeleteHoldTest.this.beforeDeleteHoldFlag);
            }

            @Override
            public void when() {
                DeleteHoldTest.this.holdService.deleteHold(this.hold);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)DeleteHoldTest.this.beforeDeleteHoldFlag);
                TestCase.assertTrue((boolean)DeleteHoldTest.this.onDeleteHoldFlag);
            }

            @Override
            public void after() {
                DeleteHoldTest.this.policyComponent.removeClassDefinition(this.beforeDeleteHoldBehaviour);
                DeleteHoldTest.this.policyComponent.removeClassDefinition(this.onDeleteHoldBehaviour);
            }
        });
    }

    public void beforeDeleteHold(NodeRef hold) {
        this.beforeDeleteHoldFlag = true;
    }

    public void onDeleteHold(String holdName) {
        this.onDeleteHoldFlag = true;
    }
}

