/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.module.org_alfresco_module_rm.version.TestRecordableVersionServiceImpl;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RecordableVersionServiceImplUnitTest
extends BaseUnitTest {
    private static final String CONTENT_NAME = "test.txt";
    private NodeRef nodeRef;
    private NodeRef record;
    private NodeRef unfiledRecordContainer;
    private NodeRef version;
    private Map<String, Serializable> versionProperties;
    @Mock(name="dbNodeService")
    private NodeService mockedDbNodeService;
    @InjectMocks
    @Spy
    private TestRecordableVersionServiceImpl recordableVersionService;

    @Override
    public void before() throws Exception {
        super.before();
        this.nodeRef = this.generateCmContent(CONTENT_NAME);
        ((NodeService)Mockito.doReturn((Object)123L).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, ContentModel.PROP_NODE_DBID);
        this.versionProperties = new HashMap<String, Serializable>(5);
        this.recordableVersionService.initialise();
        ((NodeService)Mockito.doReturn((Object)this.generateChildAssociationRef(null, this.generateNodeRef(Version2Model.TYPE_QNAME_VERSION_HISTORY))).when((Object)this.mockedDbNodeService)).createNode((NodeRef)ArgumentMatchers.nullable(NodeRef.class), (QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.eq((Object)Version2Model.TYPE_QNAME_VERSION_HISTORY), (Map)ArgumentMatchers.nullable(Map.class));
        ((FilePlanService)Mockito.doReturn((Object)this.filePlan).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        this.record = this.generateCmContent(CONTENT_NAME);
        this.version = this.generateNodeRef(TYPE_CONTENT);
        ((NodeService)Mockito.doReturn((Object)this.generateChildAssociationRef(null, this.version)).when((Object)this.mockedDbNodeService)).createNode((NodeRef)ArgumentMatchers.nullable(NodeRef.class), (QName)ArgumentMatchers.eq((Object)Version2Model.CHILD_QNAME_VERSIONS), (QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.eq((Object)TYPE_CONTENT), (Map)ArgumentMatchers.nullable(Map.class));
        this.recordableVersionService.setDbNodeService(this.mockedDbNodeService);
    }

    @Test
    public void noAspect() throws Exception {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        this.verifyNormalVersion();
    }

    @Test
    public void policyNull() throws Exception {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        this.verifyNormalVersion();
    }

    @Test
    public void policyNone() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.NONE.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        this.verifyNormalVersion();
    }

    @Test
    public void policyAllVersionMinor() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.ALL.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    private void verifyNormalVersion() throws Exception {
        ((FilePlanService)Mockito.verify((Object)this.mockedFilePlanService, (VerificationMode)Mockito.never())).getUnfiledContainer((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((FileFolderService)Mockito.verify((Object)this.mockedFileFolderService, (VerificationMode)Mockito.never())).copy((NodeRef)ArgumentMatchers.eq((Object)this.nodeRef), (NodeRef)ArgumentMatchers.eq((Object)this.unfiledRecordContainer), ArgumentMatchers.anyString());
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService, (VerificationMode)Mockito.times((int)1))).createNode((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)Version2Model.CHILD_QNAME_VERSIONS), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)TYPE_CONTENT), ArgumentMatchers.anyMap());
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.version), (QName)ArgumentMatchers.eq((Object)Version2Model.ASPECT_VERSION), ArgumentMatchers.anyMap());
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).addAspect((NodeRef)ArgumentMatchers.eq((Object)this.version), (QName)ArgumentMatchers.eq((Object)RecordableVersionModel.PROP_RECORD_NODE_REF), ArgumentMatchers.anyMap());
    }

    @Test
    public void policyAllVersionMajor() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.ALL.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void policyMajorOnlyVersionMinor() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.MAJOR_ONLY.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        this.verifyNormalVersion();
    }

    @Test
    public void policyMajorOnlyVersionMajor() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.MAJOR_ONLY.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void noFilePlan() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.MAJOR_ONLY.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        ((FilePlanService)Mockito.doReturn(null).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        this.exception.expect(AlfrescoRuntimeException.class);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
    }

    @Test
    public void filePlanSpecifiedWithPolicy() throws Exception {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, RecordableVersionModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)RecordableVersionPolicy.MAJOR_ONLY.toString()).when((Object)this.mockedNodeService)).getProperty(this.nodeRef, RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY);
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        NodeRef anotherFilePlan = this.generateNodeRef(TYPE_FILE_PLAN);
        this.versionProperties.put("file-plan", (Serializable)anotherFilePlan);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)0))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void filePlanSpecifiedNoPolicy() throws Exception {
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        this.versionProperties.put("recordable-version", Boolean.valueOf(true));
        NodeRef anotherFilePlan = this.generateNodeRef(TYPE_FILE_PLAN);
        this.versionProperties.put("file-plan", (Serializable)anotherFilePlan);
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)0))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void adHocRecordedVersionNoPolicy() throws Exception {
        this.versionProperties.put("versionType", (Serializable)VersionType.MAJOR);
        this.versionProperties.put("recordable-version", Boolean.valueOf(true));
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void adHocRecordedVersionOverridePolicy() throws Exception {
        this.versionProperties.put("versionType", (Serializable)VersionType.MINOR);
        this.versionProperties.put("recordable-version", Boolean.valueOf(true));
        this.recordableVersionService.createVersion(this.nodeRef, this.versionProperties);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromCopy(this.filePlan, this.nodeRef);
    }

    @Test
    public void notVersionableCreateRecordFromVersion() {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.recordableVersionService.createRecordFromLatestVersion(this.filePlan, this.nodeRef);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).createRecordFromCopy((NodeRef)ArgumentMatchers.eq((Object)this.filePlan), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test
    public void alreadyRecordedCreateRecordFromVersion() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION)).thenReturn((Object)true);
        ((TestRecordableVersionServiceImpl)((Object)Mockito.doReturn((Object)mockedVersion).when((Object)this.recordableVersionService))).getCurrentVersion(this.nodeRef);
        this.recordableVersionService.createRecordFromLatestVersion(this.filePlan, this.nodeRef);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.never())).createRecordFromCopy((NodeRef)ArgumentMatchers.eq((Object)this.filePlan), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test
    public void notRecordedCreateRecordFromVersion() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        NodeRef versionHistoryNodeRef = this.generateNodeRef();
        ((NodeService)Mockito.doReturn((Object)versionHistoryNodeRef).when((Object)this.mockedDbNodeService)).getChildByName((NodeRef)ArgumentMatchers.nullable(NodeRef.class), (QName)ArgumentMatchers.eq((Object)Version2Model.CHILD_QNAME_VERSION_HISTORIES), (String)ArgumentMatchers.nullable(String.class));
        ((TestRecordableVersionServiceImpl)((Object)Mockito.doReturn((Object)mockedVersion).when((Object)this.recordableVersionService))).getCurrentVersion(this.nodeRef);
        ((TestRecordableVersionServiceImpl)((Object)Mockito.doReturn((Object)versionNodeRef).when((Object)this.recordableVersionService))).convertNodeRef((NodeRef)ArgumentMatchers.nullable(NodeRef.class));
        this.makePrimaryParentOf(versionNodeRef, versionHistoryNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"something-0"), this.mockedDbNodeService);
        NodeRef newVersionNodeRef = this.generateNodeRef();
        ((NodeService)Mockito.doReturn((Object)this.generateChildAssociationRef(versionHistoryNodeRef, newVersionNodeRef)).when((Object)this.mockedDbNodeService)).createNode((NodeRef)ArgumentMatchers.eq((Object)versionHistoryNodeRef), (QName)ArgumentMatchers.eq((Object)Version2Model.CHILD_QNAME_VERSIONS), (QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.nullable(QName.class), (Map)ArgumentMatchers.nullable(Map.class));
        NodeRef newRecordNodeRef = this.generateNodeRef();
        ((RecordService)Mockito.doReturn((Object)newRecordNodeRef).when((Object)this.mockedRecordService)).createRecordFromContent((NodeRef)ArgumentMatchers.eq((Object)this.filePlan), (String)ArgumentMatchers.nullable(String.class), (QName)ArgumentMatchers.nullable(QName.class), (Map)ArgumentMatchers.nullable(Map.class), (ContentReader)ArgumentMatchers.nullable(ContentReader.class));
        this.recordableVersionService.createRecordFromLatestVersion(this.filePlan, this.nodeRef);
        ((RecordService)Mockito.verify((Object)this.mockedRecordService, (VerificationMode)Mockito.times((int)1))).createRecordFromContent((NodeRef)ArgumentMatchers.eq((Object)this.filePlan), (String)ArgumentMatchers.nullable(String.class), (QName)ArgumentMatchers.nullable(QName.class), (Map)ArgumentMatchers.any(Map.class), (ContentReader)ArgumentMatchers.nullable(ContentReader.class));
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService, (VerificationMode)Mockito.times((int)1))).deleteNode((NodeRef)ArgumentMatchers.any(NodeRef.class));
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService, (VerificationMode)Mockito.times((int)1))).createNode((NodeRef)ArgumentMatchers.eq((Object)versionHistoryNodeRef), (QName)ArgumentMatchers.eq((Object)Version2Model.CHILD_QNAME_VERSIONS), (QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.nullable(QName.class), (Map)ArgumentMatchers.nullable(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect((NodeRef)ArgumentMatchers.eq((Object)newVersionNodeRef), (QName)ArgumentMatchers.eq((Object)Version2Model.ASPECT_VERSION), (Map)ArgumentMatchers.any(Map.class));
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect(newVersionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION, Collections.singletonMap(RecordableVersionModel.PROP_RECORD_NODE_REF, newRecordNodeRef));
    }

    @Test
    public void propNotSetVersionNotDestroyed() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedDbNodeService.getProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED)).thenReturn(null);
        Assert.assertFalse((boolean)this.recordableVersionService.isRecordedVersionDestroyed(mockedVersion));
    }

    @Test
    public void propSetVersionDestroyed() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedDbNodeService.getProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED)).thenReturn((Object)Boolean.TRUE);
        Assert.assertTrue((boolean)this.recordableVersionService.isRecordedVersionDestroyed(mockedVersion));
        Mockito.when((Object)this.mockedDbNodeService.getProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED)).thenReturn((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)this.recordableVersionService.isRecordedVersionDestroyed(mockedVersion));
    }

    @Test
    public void noAspectMarkAsDestroyed() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedDbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION)).thenReturn((Object)false);
        this.recordableVersionService.destroyRecordedVersion(mockedVersion);
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService, (VerificationMode)Mockito.never())).setProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED, (Serializable)Boolean.TRUE);
    }

    @Test
    public void markAsDestroyed() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedDbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION)).thenReturn((Object)true);
        this.recordableVersionService.destroyRecordedVersion(mockedVersion);
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService)).setProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED, (Serializable)Boolean.TRUE);
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService)).setProperty(versionNodeRef, RecordableVersionModel.PROP_RECORD_NODE_REF, null);
    }

    @Test
    public void markAsDestroyedClearNodeRef() {
        Version mockedVersion = (Version)Mockito.mock(VersionImpl.class);
        NodeRef versionNodeRef = this.generateNodeRef();
        Mockito.when((Object)mockedVersion.getFrozenStateNodeRef()).thenReturn((Object)versionNodeRef);
        Mockito.when((Object)this.mockedDbNodeService.hasAspect(versionNodeRef, RecordableVersionModel.ASPECT_RECORDED_VERSION)).thenReturn((Object)true);
        this.recordableVersionService.destroyRecordedVersion(mockedVersion);
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService)).setProperty(versionNodeRef, RecordableVersionModel.PROP_DESTROYED, (Serializable)Boolean.TRUE);
        ((NodeService)Mockito.verify((Object)this.mockedDbNodeService)).setProperty(versionNodeRef, RecordableVersionModel.PROP_RECORD_NODE_REF, null);
    }
}

