/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.extractor;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.PermissionService;

public final class NamePathDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private RuleService ruleService;
    private PermissionService permissionService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public boolean isSupported(Serializable data) {
        if (!(data instanceof NodeRef)) {
            return false;
        }
        NodeRef nodeRef = (NodeRef)data;
        return this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT) || this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable extractData(Serializable value) {
        String extractedData;
        this.ruleService.disableRules();
        try {
            NodeRef nodeRef = (NodeRef)value;
            StringBuilder sb = new StringBuilder(128);
            if (this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
                List<NodeRef> nodeRefPath = this.filePlanService.getNodeRefPath(nodeRef);
                NodeRef filePlan = this.filePlanService.getFilePlan(nodeRef);
                nodeRefPath.add(0, this.nodeService.getPrimaryParent(filePlan).getParentRef());
                for (NodeRef pathNodeRef : nodeRefPath) {
                    String name = (String)((Object)this.nodeService.getProperty(pathNodeRef, ContentModel.PROP_NAME));
                    sb.append("/").append(name);
                }
            } else if (this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT)) {
                Path nodeRefPath = this.nodeService.getPath(nodeRef);
                sb.append(nodeRefPath.toDisplayPath(this.nodeService, this.permissionService));
                String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                sb.append("/").append(name);
            }
            extractedData = sb.toString();
        }
        finally {
            this.ruleService.enableRules();
        }
        return extractedData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamePathDataExtractor that = (NamePathDataExtractor)((Object)o);
        return Objects.equals(this.nodeService, that.nodeService) && Objects.equals(this.filePlanService, that.filePlanService) && Objects.equals(this.ruleService, that.ruleService);
    }

    public int hashCode() {
        return Objects.hash(this.nodeService, this.filePlanService, this.ruleService);
    }
}

