/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;

public class ViewRecordTest
extends BaseRMTestCase {
    public void testReadIsFiledPropertyWithoutReadPermissionOnParentFolder() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String roleName = GUID.generate();
            String user = GUID.generate();
            NodeRef rc;
            NodeRef recordFolder;
            NodeRef record;
            boolean recordIsFiled = false;

            @Override
            public void given() {
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(ViewRecordTest.this.capabilityService.getCapability("ViewRecords"));
                ViewRecordTest.this.filePlanRoleService.createRole(ViewRecordTest.this.filePlan, this.roleName, this.roleName, capabilities);
                ViewRecordTest.this.createPerson(this.user, true);
                ViewRecordTest.this.filePlanRoleService.assignRoleToAuthority(ViewRecordTest.this.filePlan, this.roleName, this.user);
                this.rc = ViewRecordTest.this.filePlanService.createRecordCategory(ViewRecordTest.this.filePlan, GUID.generate());
                NodeRef rsc = ViewRecordTest.this.filePlanService.createRecordCategory(this.rc, GUID.generate());
                this.recordFolder = ViewRecordTest.this.recordFolderService.createRecordFolder(rsc, GUID.generate());
                this.record = ViewRecordTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
            }

            @Override
            public void when() {
                ViewRecordTest.this.filePlanPermissionService.setPermission(this.rc, this.user, "ReadRecords");
                ViewRecordTest.this.permissionService.setInheritParentPermissions(this.recordFolder, false);
                ViewRecordTest.this.filePlanPermissionService.setPermission(this.record, this.user, "ReadRecords");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        recordIsFiled = ViewRecordTest.this.recordService.isFiled(record);
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)this.recordIsFiled);
            }
        });
    }
}

