/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.event;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.GUID;

public class CompleteEventsTest
extends BaseRMTestCase {
    private static final String ANOTHER_EVENT = "abolished";

    public void testCompleteSingleEventRecordLevel() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", true, true);
                NodeRef recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                this.record = CompleteEventsTest.this.utils.createRecord(recordFolder, GUID.generate(), "title");
                CompleteEventsTest.this.utils.completeRecord(this.record);
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.record, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }

    public void testCompleteSimpleSingleEventRecordFolderLevel() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef recordFolder;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", false, true);
                this.recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                NodeRef record = CompleteEventsTest.this.utils.createRecord(this.recordFolder, GUID.generate(), "title");
                CompleteEventsTest.this.utils.completeRecord(record);
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.recordFolder));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.recordFolder);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }

    public void testAtLeastOneEventToBeEligible() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                DispositionSchedule mySchedule = CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", false, false);
                HashMap<QName, Object> adParams = new HashMap<QName, Object>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "disposition action description");
                ArrayList<String> events = new ArrayList<String>(1);
                events.add("case_closed");
                events.add(CompleteEventsTest.ANOTHER_EVENT);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, events);
                CompleteEventsTest.this.dispositionService.addDispositionActionDefinition(mySchedule, adParams);
                this.recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                NodeRef record = CompleteEventsTest.this.utils.createRecord(this.recordFolder, GUID.generate(), "title");
                CompleteEventsTest.this.utils.completeRecord(record);
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.recordFolder));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.recordFolder);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
                eventDetails = dispositionAction.getEventCompletionDetails(CompleteEventsTest.ANOTHER_EVENT);
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)CompleteEventsTest.ANOTHER_EVENT, (String)eventDetails.getEventName());
                TestCase.assertFalse((boolean)eventDetails.isEventComplete());
                TestCase.assertNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }

    public void testOnlyOneOfAllEventsSoNotEligible() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                DispositionSchedule mySchedule = CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", false, false);
                HashMap<QName, Object> adParams = new HashMap<QName, Object>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "disposition action description");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT_COMBINATION, "and");
                ArrayList<String> events = new ArrayList<String>(1);
                events.add("case_closed");
                events.add(CompleteEventsTest.ANOTHER_EVENT);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, events);
                CompleteEventsTest.this.dispositionService.addDispositionActionDefinition(mySchedule, adParams);
                this.recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                NodeRef record = CompleteEventsTest.this.utils.createRecord(this.recordFolder, GUID.generate(), "title");
                CompleteEventsTest.this.utils.completeRecord(record);
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.recordFolder));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.recordFolder);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
                eventDetails = dispositionAction.getEventCompletionDetails(CompleteEventsTest.ANOTHER_EVENT);
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)CompleteEventsTest.ANOTHER_EVENT, (String)eventDetails.getEventName());
                TestCase.assertFalse((boolean)eventDetails.isEventComplete());
                TestCase.assertNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }

    public void testAllEventsSoEligible() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef recordFolder = null;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                DispositionSchedule mySchedule = CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", false, false);
                HashMap<QName, Object> adParams = new HashMap<QName, Object>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "disposition action description");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT_COMBINATION, "and");
                ArrayList<String> events = new ArrayList<String>(1);
                events.add("case_closed");
                events.add(CompleteEventsTest.ANOTHER_EVENT);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, events);
                CompleteEventsTest.this.dispositionService.addDispositionActionDefinition(mySchedule, adParams);
                this.recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                NodeRef record = CompleteEventsTest.this.utils.createRecord(this.recordFolder, GUID.generate(), "title");
                CompleteEventsTest.this.utils.completeRecord(record);
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
                params = new HashMap(1);
                params.put("eventName", CompleteEventsTest.ANOTHER_EVENT);
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.recordFolder, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.recordFolder));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.recordFolder);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
                eventDetails = dispositionAction.getEventCompletionDetails(CompleteEventsTest.ANOTHER_EVENT);
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)CompleteEventsTest.ANOTHER_EVENT, (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }

    public void testCompleteEventWhenCutoffMultiFiled_RM1341() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;

            @Override
            public void given() {
                NodeRef recordCategory = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                NodeRef recordCategory2 = CompleteEventsTest.this.filePlanService.createRecordCategory(CompleteEventsTest.this.filePlan, GUID.generate());
                CompleteEventsTest.this.utils.createBasicDispositionSchedule(recordCategory, "instructions", "authority", true, true);
                NodeRef recordFolder = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                NodeRef recordFolder2 = CompleteEventsTest.this.recordFolderService.createRecordFolder(recordCategory2, GUID.generate());
                String recordName = GUID.generate();
                this.record = CompleteEventsTest.this.utils.createRecord(recordFolder, recordName, "title");
                CompleteEventsTest.this.utils.completeRecord(this.record);
                CompleteEventsTest.this.nodeService.addChild(recordFolder2, this.record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)recordName));
            }

            @Override
            public void when() {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                CompleteEventsTest.this.rmActionService.executeRecordsManagementAction(this.record, "completeEvent", params);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CompleteEventsTest.this.dispositionService.isNextDispositionActionEligible(this.record));
                DispositionAction dispositionAction = CompleteEventsTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                EventCompletionDetails eventDetails = dispositionAction.getEventCompletionDetails("case_closed");
                TestCase.assertNotNull((Object)eventDetails);
                TestCase.assertEquals((String)"case_closed", (String)eventDetails.getEventName());
                TestCase.assertTrue((boolean)eventDetails.isEventComplete());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedAt());
                TestCase.assertNotNull((Object)eventDetails.getEventCompletedBy());
            }
        });
    }
}

