/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class FreezeServiceImplTest
extends BaseRMTestCase {
    private List<NodeRef> holdAssocs;

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testFreezeService() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordService.isRecord(FreezeServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordService.isRecord(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordService.isRecord(FreezeServiceImplTest.this.recordThree));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordService.isRecord(FreezeServiceImplTest.this.recordFour));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.filePlanService.isFilePlanComponent(FreezeServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.filePlanService.isFilePlanComponent(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.filePlanService.isFilePlanComponent(FreezeServiceImplTest.this.recordThree));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.filePlanService.isFilePlanComponent(FreezeServiceImplTest.this.recordFour));
                NodeRef hold101 = FreezeServiceImplTest.this.holdService.createHold(FreezeServiceImplTest.this.filePlan, "freezename 101", "FreezeReason", null);
                TestCase.assertNotNull((Object)hold101);
                FreezeServiceImplTest.this.holdService.addToHold(hold101, FreezeServiceImplTest.this.recordOne);
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertNotNull(FreezeServiceImplTest.this.holdAssocs);
                TestCase.assertEquals((int)1, (int)FreezeServiceImplTest.this.holdAssocs.size());
                NodeRef holdNodeRef = FreezeServiceImplTest.this.holdAssocs.iterator().next();
                TestCase.assertEquals((Object)holdNodeRef, (Object)hold101);
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.holdService.isHold(holdNodeRef));
                TestCase.assertEquals((String)"FreezeReason", (String)FreezeServiceImplTest.this.holdService.getHoldReason(holdNodeRef));
                List frozenNodes = FreezeServiceImplTest.this.holdService.getHeld(holdNodeRef);
                TestCase.assertNotNull((Object)frozenNodes);
                TestCase.assertEquals((int)1, (int)frozenNodes.size());
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordOne));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeDate(FreezeServiceImplTest.this.recordOne));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeInitiator(FreezeServiceImplTest.this.recordOne));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordThree));
                FreezeServiceImplTest.this.holdService.setHoldReason(holdNodeRef, "NewFreezeReason");
                TestCase.assertEquals((String)"NewFreezeReason", (String)FreezeServiceImplTest.this.holdService.getHoldReason(holdNodeRef));
                ArrayList<NodeRef> records = new ArrayList<NodeRef>();
                records.add(FreezeServiceImplTest.this.recordOne);
                records.add(FreezeServiceImplTest.this.recordTwo);
                records.add(FreezeServiceImplTest.this.recordThree);
                NodeRef newHold = FreezeServiceImplTest.this.holdService.createHold(FreezeServiceImplTest.this.filePlan, "Hold 102", "Freeze a set of nodes", null);
                FreezeServiceImplTest.this.holdService.addToHold(newHold, records);
                TestCase.assertNotNull((Object)newHold);
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.holdService.isHold(newHold));
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertNotNull(FreezeServiceImplTest.this.holdAssocs);
                TestCase.assertEquals((int)2, (int)FreezeServiceImplTest.this.holdAssocs.size());
                for (NodeRef hold : FreezeServiceImplTest.this.holdAssocs) {
                    String reason = FreezeServiceImplTest.this.holdService.getHoldReason(hold);
                    if (reason.equals("Freeze a set of nodes")) {
                        TestCase.assertEquals((Object)newHold, (Object)hold);
                        frozenNodes = FreezeServiceImplTest.this.holdService.getHeld(hold);
                        TestCase.assertNotNull((Object)frozenNodes);
                        TestCase.assertEquals((int)3, (int)frozenNodes.size());
                        continue;
                    }
                    if (reason.equals("NewFreezeReason")) {
                        frozenNodes = FreezeServiceImplTest.this.holdService.getHeld(hold);
                        TestCase.assertNotNull((Object)frozenNodes);
                        TestCase.assertEquals((int)1, (int)frozenNodes.size());
                        continue;
                    }
                    throw new AlfrescoRuntimeException("The reason '" + reason + "' was not found in the existing holds.");
                }
                List<NodeRef> testRecords = Arrays.asList(FreezeServiceImplTest.this.recordOne, FreezeServiceImplTest.this.recordTwo, FreezeServiceImplTest.this.recordThree);
                for (NodeRef nr : testRecords) {
                    TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(nr));
                    TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeDate(nr));
                    TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeInitiator(nr));
                }
                FreezeServiceImplTest.this.holdService.removeFromAllHolds(FreezeServiceImplTest.this.recordThree);
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertNotNull(FreezeServiceImplTest.this.holdAssocs);
                TestCase.assertEquals((int)2, (int)FreezeServiceImplTest.this.holdAssocs.size());
                for (NodeRef hold : FreezeServiceImplTest.this.holdAssocs) {
                    String reason = FreezeServiceImplTest.this.holdService.getHoldReason(hold);
                    if (reason.equals("Freeze a set of nodes")) {
                        frozenNodes = FreezeServiceImplTest.this.holdService.getHeld(hold);
                        TestCase.assertNotNull((Object)frozenNodes);
                        TestCase.assertEquals((int)2, (int)frozenNodes.size());
                        continue;
                    }
                    if (reason.equals("NewFreezeReason")) {
                        frozenNodes = FreezeServiceImplTest.this.holdService.getHeld(hold);
                        TestCase.assertNotNull((Object)frozenNodes);
                        TestCase.assertEquals((int)1, (int)frozenNodes.size());
                        continue;
                    }
                    throw new AlfrescoRuntimeException("The reason '" + reason + "' was not found in the existing holds.");
                }
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordOne));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeDate(FreezeServiceImplTest.this.recordOne));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeInitiator(FreezeServiceImplTest.this.recordOne));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeDate(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertNotNull((Object)FreezeServiceImplTest.this.freezeService.getFreezeInitiator(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordThree));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordFour));
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef holdNodeRef = FreezeServiceImplTest.this.holdAssocs.iterator().next();
                FreezeServiceImplTest.this.holdService.deleteHold(holdNodeRef);
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertNotNull(FreezeServiceImplTest.this.holdAssocs);
                TestCase.assertEquals((int)1, (int)FreezeServiceImplTest.this.holdAssocs.size());
                holdNodeRef = FreezeServiceImplTest.this.holdAssocs.iterator().next();
                FreezeServiceImplTest.this.holdService.removeFromAllHolds(FreezeServiceImplTest.this.holdService.getHeld(holdNodeRef));
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertEquals((int)1, (int)FreezeServiceImplTest.this.holdAssocs.size());
                FreezeServiceImplTest.this.holdService.deleteHold(holdNodeRef);
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertEquals((int)0, (int)FreezeServiceImplTest.this.holdAssocs.size());
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordOne));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordThree));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordFour));
                NodeRef hold = FreezeServiceImplTest.this.holdService.createHold(FreezeServiceImplTest.this.filePlan, "hold 1", "AnotherFreezeReason", "description");
                FreezeServiceImplTest.this.holdService.addToHold(hold, FreezeServiceImplTest.this.recordFour);
                FreezeServiceImplTest.this.holdService.addToHold(hold, FreezeServiceImplTest.this.recordOne);
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(FreezeServiceImplTest.this.recordTwo);
                nodes.add(FreezeServiceImplTest.this.recordThree);
                FreezeServiceImplTest.this.holdService.addToHold(hold, nodes);
                FreezeServiceImplTest.this.holdAssocs = FreezeServiceImplTest.this.holdService.getHolds(FreezeServiceImplTest.this.filePlan);
                TestCase.assertNotNull(FreezeServiceImplTest.this.holdAssocs);
                TestCase.assertEquals((int)1, (int)FreezeServiceImplTest.this.holdAssocs.size());
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                FreezeServiceImplTest.this.holdService.deleteHold(FreezeServiceImplTest.this.holdAssocs.iterator().next());
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordOne));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordTwo));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordThree));
                TestCase.assertFalse((boolean)FreezeServiceImplTest.this.freezeService.isFrozen(FreezeServiceImplTest.this.recordFour));
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef hold101 = FreezeServiceImplTest.this.holdService.createHold(FreezeServiceImplTest.this.filePlan, "freezename 103", "FreezeReason", null);
                TestCase.assertNotNull((Object)hold101);
                FreezeServiceImplTest.this.holdService.addToHold(hold101, FreezeServiceImplTest.this.rmFolder);
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordFolderService.isRecordFolder(FreezeServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozenOrHasFrozenChildren(FreezeServiceImplTest.this.rmFolder));
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                NodeRef hold101 = FreezeServiceImplTest.this.holdService.createHold(FreezeServiceImplTest.this.filePlan, "freezename 104", "FreezeReason", null);
                TestCase.assertNotNull((Object)hold101);
                FreezeServiceImplTest.this.holdService.addToHold(hold101, FreezeServiceImplTest.this.recordThree);
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.recordService.isRecord(FreezeServiceImplTest.this.recordThree));
                TestCase.assertTrue((boolean)FreezeServiceImplTest.this.freezeService.isFrozenOrHasFrozenChildren(FreezeServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }
}

