/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.identifier;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierGenerator;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentifierServiceImpl
implements IdentifierService {
    private static Log logger = LogFactory.getLog(IdentifierServiceImpl.class);
    private Map<QName, IdentifierGenerator> register = new HashMap<QName, IdentifierGenerator>(5);
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public String generateIdentifier(QName type, NodeRef parent) {
        ParameterCheck.mandatory((String)"type", (Object)type);
        HashMap<String, Serializable> context = new HashMap<String, Serializable>(2);
        if (parent != null) {
            context.put("parentndoeref", (Serializable)parent);
        }
        context.put("origionaltype", (Serializable)type);
        return this.generateIdentifier(type, context);
    }

    @Override
    public String generateIdentifier(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        HashMap<String, Serializable> context = new HashMap<String, Serializable>(3);
        QName type = this.nodeService.getType(nodeRef);
        context.put("origionaltype", (Serializable)type);
        ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (assocRef != null && assocRef.getParentRef() != null) {
            context.put("parentndoeref", (Serializable)assocRef.getParentRef());
        }
        context.put("noderef", (Serializable)nodeRef);
        return this.generateIdentifier(type, context);
    }

    private String generateIdentifier(QName type, Map<String, Serializable> context) {
        ParameterCheck.mandatory((String)"type", (Object)type);
        ParameterCheck.mandatory((String)"context", context);
        IdentifierGenerator idGen = this.lookupGenerator(type);
        if (idGen == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to generate id for object of type " + type.toString() + ", because no identifier generator was found."));
            }
            throw new AlfrescoRuntimeException("Unable to generate id for object of type " + type.toString() + ", because no identifier generator was found.");
        }
        return idGen.generateId(context);
    }

    @Override
    public void register(IdentifierGenerator idGen) {
        this.register.put(idGen.getType(), idGen);
    }

    private IdentifierGenerator lookupGenerator(QName type) {
        IdentifierGenerator result;
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for idGenerator for type " + type.toString()));
        }
        if ((result = this.register.get(type)) == null) {
            ClassDefinition typeDef = this.dictionaryService.getClass(type);
            if (typeDef != null) {
                QName parentType = typeDef.getParentName();
                if (parentType != null) {
                    result = this.lookupGenerator(parentType);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find type definition for " + type.toString() + " when generating identifier."));
            }
        }
        return result;
    }
}

