/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition;

import org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition.FillingOnHoldContainerCapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class FillingOnHoldContainerCapabilityConditionUnitTest
extends BaseUnitTest {
    @InjectMocks
    private FillingOnHoldContainerCapabilityCondition condition;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
    }

    @Test
    public void noFillingOnHoldContainer() {
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedFilePlanService.isFilePlan(holdContainer)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(holdContainer, "FileRecords")).thenReturn((Object)AccessStatus.DENIED);
        Assert.assertFalse((boolean)this.condition.evaluateImpl(holdContainer));
    }

    @Test
    public void fillingOnHoldContainer() {
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedFilePlanService.isFilePlan(holdContainer)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(holdContainer, "FileRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        Assert.assertTrue((boolean)this.condition.evaluateImpl(holdContainer));
    }

    @Test
    public void filePlanNoFilling() {
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedFilePlanService.getHoldContainer(this.filePlan)).thenReturn((Object)holdContainer);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(holdContainer, "FileRecords")).thenReturn((Object)AccessStatus.DENIED);
        Assert.assertFalse((boolean)this.condition.evaluateImpl(holdContainer));
    }

    @Test
    public void filePlanFilling() {
        NodeRef holdContainer = this.generateNodeRef(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedFilePlanService.getHoldContainer(this.filePlan)).thenReturn((Object)holdContainer);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(holdContainer, "FileRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        Assert.assertTrue((boolean)this.condition.evaluateImpl(holdContainer));
    }

    @Test
    public void unexpectedNode() {
        NodeRef unexpectedNode = this.generateNodeRef();
        Mockito.when((Object)this.mockedFilePlanService.isFilePlan(unexpectedNode)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPermissionService.hasPermission(unexpectedNode, "FileRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        Assert.assertFalse((boolean)this.condition.evaluateImpl(unexpectedNode));
    }
}

