/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.module.org_alfresco_module_rm.test.util.CommonRMTestUtils;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;

public class BaseRMWebScriptTestCase
extends BaseWebScriptTest {
    protected CommonRMTestUtils utils;
    protected ApplicationContext applicationContext;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected DictionaryService dictionaryService;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected PolicyComponent policyComponent;
    protected NamespaceService namespaceService;
    protected SearchService searchService;
    protected SiteService siteService;
    protected MutableAuthenticationService authenticationService;
    protected AuthorityService authorityService;
    protected PersonService personService;
    protected TransactionService transactionService;
    protected TaggingService taggingService;
    protected DispositionService dispositionService;
    protected RecordsManagementEventService eventService;
    protected RecordsManagementAdminService adminService;
    protected RecordsManagementActionService actionService;
    protected RecordsManagementSearchService rmSearchService;
    protected FilePlanRoleService filePlanRoleService;
    protected FilePlanPermissionService filePlanPermissionService;
    protected RecordsManagementAuditService auditService;
    protected CapabilityService capabilityService;
    protected VitalRecordService vitalRecordService;
    protected FilePlanService filePlanService;
    protected RecordFolderService recordFolderService;
    protected RMCaveatConfigService caveatConfigService;
    protected String siteId;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected SiteInfo siteInfo;
    protected NodeRef folder;
    protected NodeRef filePlan;
    protected NodeRef recordSeries;
    protected NodeRef recordCategory;
    protected DispositionSchedule dispositionSchedule;
    protected NodeRef recordFolder;
    protected NodeRef recordFolder2;
    protected String collabSiteId;
    protected static final String ADMIN_USER = "admin";

    protected boolean isCollaborationSiteTest() {
        return false;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initServices();
        this.setupTestData();
    }

    protected void initServices() {
        this.applicationContext = this.getServer().getApplicationContext();
        this.utils = new CommonRMTestUtils(this.applicationContext);
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.retryingTransactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("DictionaryService");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.taggingService = (TaggingService)this.applicationContext.getBean("TaggingService");
        this.dispositionService = (DispositionService)this.applicationContext.getBean("DispositionService");
        this.eventService = (RecordsManagementEventService)this.applicationContext.getBean("RecordsManagementEventService");
        this.adminService = (RecordsManagementAdminService)this.applicationContext.getBean("RecordsManagementAdminService");
        this.actionService = (RecordsManagementActionService)this.applicationContext.getBean("RecordsManagementActionService");
        this.rmSearchService = (RecordsManagementSearchService)this.applicationContext.getBean("RecordsManagementSearchService");
        this.filePlanRoleService = (FilePlanRoleService)this.applicationContext.getBean("FilePlanRoleService");
        this.filePlanPermissionService = (FilePlanPermissionService)this.applicationContext.getBean("FilePlanPermissionService");
        this.auditService = (RecordsManagementAuditService)this.applicationContext.getBean("RecordsManagementAuditService");
        this.capabilityService = (CapabilityService)this.applicationContext.getBean("CapabilityService");
        this.vitalRecordService = (VitalRecordService)this.applicationContext.getBean("VitalRecordService");
        this.filePlanService = (FilePlanService)this.applicationContext.getBean("FilePlanService");
        this.recordFolderService = (RecordFolderService)this.applicationContext.getBean("RecordFolderService");
        this.caveatConfigService = (RMCaveatConfigService)this.applicationContext.getBean("CaveatConfigService");
    }

    protected void tearDown() throws Exception {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                BaseRMWebScriptTestCase.this.tearDownImpl();
                return null;
            }
        });
    }

    protected void tearDownImpl() {
        this.nodeService.deleteNode(this.folder);
        this.siteService.deleteSite(this.siteId);
        if (this.isCollaborationSiteTest()) {
            this.siteService.deleteSite(this.collabSiteId);
        }
    }

    protected void setupTestData() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                BaseRMWebScriptTestCase.this.setupTestDataImpl();
                return null;
            }
        });
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                BaseRMWebScriptTestCase.this.filePlanRoleService.assignRoleToAuthority(BaseRMWebScriptTestCase.this.filePlan, "Administrator", BaseRMWebScriptTestCase.ADMIN_USER);
                return null;
            }
        });
    }

    protected void setupTestDataImpl() {
        this.storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        String containerName = "RM2_" + System.currentTimeMillis();
        HashMap<QName, CallSite> containerProps = new HashMap<QName, CallSite>(1);
        containerProps.put(ContentModel.PROP_NAME, (CallSite)((Object)containerName));
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)containerName), ContentModel.TYPE_FOLDER, containerProps).getChildRef();
        BaseRMWebScriptTestCase.assertNotNull((String)"Could not create base folder", (Object)this.folder);
        this.siteId = this.getRMSiteId();
        this.siteInfo = this.siteService.createSite("rm-site-dashboard", this.siteId, "title", "descrition", SiteVisibility.PUBLIC, RecordsManagementModel.TYPE_RM_SITE);
        this.filePlan = this.siteService.getContainer(this.siteId, "documentLibrary");
        BaseRMWebScriptTestCase.assertNotNull((String)"Site document library container was not created successfully.", (Object)this.filePlan);
        this.recordSeries = this.filePlanService.createRecordCategory(this.filePlan, "recordSeries");
        BaseRMWebScriptTestCase.assertNotNull((String)"Could not create record category with no disposition schedule", (Object)this.recordSeries);
        this.recordCategory = this.filePlanService.createRecordCategory(this.recordSeries, "rmContainer");
        BaseRMWebScriptTestCase.assertNotNull((String)"Could not create record category", (Object)this.recordCategory);
        this.vitalRecordService.setVitalRecordDefintion(this.recordCategory, true, new Period("week|1"));
        this.dispositionSchedule = this.utils.createBasicDispositionSchedule(this.recordCategory);
        this.recordFolder = this.recordFolderService.createRecordFolder(this.recordCategory, "rmFolder");
        BaseRMWebScriptTestCase.assertNotNull((String)"Could not create rm folder", (Object)this.recordFolder);
        this.recordFolder2 = this.recordFolderService.createRecordFolder(this.recordCategory, "rmFolder2");
        BaseRMWebScriptTestCase.assertNotNull((String)"Could not create rm folder 2", (Object)this.recordFolder2);
        if (this.isCollaborationSiteTest()) {
            this.setupCollaborationSiteTestData();
        }
    }

    protected void setupCollaborationSiteTestData() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                BaseRMWebScriptTestCase.this.setupCollaborationSiteTestDataImpl();
                return null;
            }
        });
    }

    protected void setupCollaborationSiteTestDataImpl() {
        this.collabSiteId = GUID.generate();
        this.siteService.createSite("preset", this.collabSiteId, "title", "description", SiteVisibility.PRIVATE);
        NodeRef documentLibrary = SiteServiceImpl.getSiteContainer((String)this.collabSiteId, (String)"documentLibrary", (boolean)true, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
        BaseRMWebScriptTestCase.assertNotNull((String)"Collaboration site document library component was not successfully created.", (Object)documentLibrary);
    }

    protected void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)("title" + userName));
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void deleteUser(String userName) {
        if (this.authenticationService.authenticationExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    protected void createGroup(String groupName) {
        if (!this.authorityService.authorityExists(groupName)) {
            this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
        }
    }

    protected void deleteGroup(String groupName) {
        if (this.authorityService.authorityExists(groupName)) {
            this.authorityService.deleteAuthority(groupName, true);
        }
    }

    protected String getRMSiteId() {
        return GUID.generate();
    }
}

